//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Runtime.InteropServices;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  This class is khtml's main class. It features an almost complete
	///  web browser, and html renderer.
	///  The easiest way to use this class (if you just want to display an HTML
	///  page at some URL) is the following:
	///  <pre>
	///  KUrl url = "http://www.kde.org";
	///  KHTMLPart w = new KHTMLPart();
	///  w.OpenUrl(url);
	///  w.View().Resize(500, 400);
	///  w.Show();
	///  </pre>
	///  Java and JavaScript are enabled by default depending on the user's
	///  settings. If you do not need them, and especially if you display
	///  unfiltered data from untrusted sources, it is strongly recommended to
	///  turn them off. In that case, you should also turn off the automatic
	///  redirect and plugins:
	///  <pre>
	///  w.SetJScriptEnabled(false);
	///  w.SetJavaEnabled(false);
	///  w.SetMetaRefreshEnabled(false);
	///  w.SetPluginsEnabled(false);
	///  </pre>
	///  You may also wish to disable external references.  This will prevent KHTML
	///  from loading images, frames, etc,  or redirecting to external sites.
	///  <pre>
	///  w.SetOnlyLocalReferences(true);
	///  </pre>
	///  Some apps want to write their HTML code directly into the widget instead of
	///  opening an url. You can do this in the following way:
	///  <pre>
	///  string myHTMLCode = ...;
	///  KHTMLPart w = new KHTMLPart();
	///  w.Begin();
	///  w.Write(myHTMLCode);
	///  ...
	///  w.End();
	///  </pre>
	///  You can do as many calls to write() as you wish.  There are two
	///  write() methods, one accepting a string and one accepting a
	///  <code>char</code> <code>argument.</code> You should use one or the other
	///  (but not both) since the method using
	///  the <code>char</code> <code>argument</code> does an additional decoding step to convert the
	///  written data to Unicode.
	///  It is also possible to write content to the HTML part using the
	///  standard streaming API from KParts.ReadOnlyPart. The usage of
	///  the API is similar to that of the begin(), write(), end() process
	///  described above as the following example shows:
	///  <pre>
	///  KHTMLPart doc = new KHTMLPart();
	///  doc.OpenStream( "text/html", KUrl() );
	///  doc.WriteStream( string( "<html><body><p>KHTML Rocks!</p></body></html>" ) );
	///  doc.CloseStream();
	///  </pre>
	///   See <see cref="IKHTMLPartSignals"></see> for signals emitted by KHTMLPart
	/// </remarks>		<author> Lars Knoll (knoll@kde.org)
	/// </author>
	/// 		<short> HTML Browser Widget.</short>

	[SmokeClass("KHTMLPart")]
	public class KHTMLPart : KParts.ReadOnlyPart, IDisposable {
 		protected KHTMLPart(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KHTMLPart), this);
		}
		public enum GUIProfile {
			DefaultGUI = 0,
			BrowserViewGUI = 1,
		}
		/// <remarks>
		///  Enumeration for displaying the caret.
		///    </remarks>		<short>    Enumeration for displaying the caret.</short>
		public enum CaretDisplayPolicy {
			CaretVisible = 0,
			CaretInvisible = 1,
			CaretBlink = 2,
		}
		/// <remarks>
		///  Extra Find options that can be used when calling the extended findText().
		///    </remarks>		<short>    Extra Find options that can be used when calling the extended findText().</short>
		public enum FindOptions {
			FindLinksOnly = 1*KFind.MinimumUserOption,
			FindNoPopups = 2*KFind.MinimumUserOption,
		}
		public enum FormNotification {
			NoNotification = 0,
			Before = 1,
			Only = 2,
			Unused = 255,
		}
		public enum PageSecurity {
			NotCrypted = 0,
			Encrypted = 1,
			Mixed = 2,
		}
		[Q_PROPERTY("bool", "javaScriptEnabled")]
		public bool JavaScriptEnabled {
			get { return (bool) interceptor.Invoke("jScriptEnabled", "jScriptEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setJScriptEnabled$", "setJScriptEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "javaEnabled")]
		public bool JavaEnabled {
			get { return (bool) interceptor.Invoke("javaEnabled", "javaEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setJavaEnabled$", "setJavaEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "dndEnabled")]
		public bool DndEnabled {
			get { return (bool) interceptor.Invoke("dndEnabled", "dndEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setDNDEnabled$", "setDNDEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "pluginsEnabled")]
		public bool PluginsEnabled {
			get { return (bool) interceptor.Invoke("pluginsEnabled", "pluginsEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setPluginsEnabled$", "setPluginsEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		[Q_PROPERTY("bool", "modified")]
		public bool Modified {
			get { return (bool) interceptor.Invoke("isModified", "isModified()", typeof(bool)); }
		}
		[Q_PROPERTY("QString", "encoding")]
		public string Encoding {
			get { return (string) interceptor.Invoke("encoding", "encoding()", typeof(string)); }
			set { interceptor.Invoke("setEncoding$", "setEncoding(QString)", typeof(void), typeof(string), value); }
		}
		[Q_PROPERTY("QString", "lastModified")]
		public string LastModified {
			get { return (string) interceptor.Invoke("lastModified", "lastModified()", typeof(string)); }
		}
		[Q_PROPERTY("bool", "metaRefreshEnabled")]
		public bool MetaRefreshEnabled {
			get { return (bool) interceptor.Invoke("metaRefreshEnabled", "metaRefreshEnabled()", typeof(bool)); }
			set { interceptor.Invoke("setMetaRefreshEnabled$", "setMetaRefreshEnabled(bool)", typeof(void), typeof(bool), value); }
		}
		// KParts::LiveConnectExtension* liveConnectExtension(const khtml::RenderPart* arg1); >>>> NOT CONVERTED
		// KJS::Interpreter* jScriptInterpreter(); >>>> NOT CONVERTED
		// KJavaAppletContext* javaContext(); >>>> NOT CONVERTED
		// KJavaAppletContext* createJavaContext(); >>>> NOT CONVERTED
		// KHTMLPart* findFrameParent(KParts::ReadOnlyPart* arg1,const QString& arg2,khtml::ChildFrame** arg3); >>>> NOT CONVERTED
		// KJSProxy* framejScript(KParts::ReadOnlyPart* arg1); >>>> NOT CONVERTED
		// void khtmlMousePressEvent(khtml::MousePressEvent* arg1); >>>> NOT CONVERTED
		// void khtmlMouseDoubleClickEvent(khtml::MouseDoubleClickEvent* arg1); >>>> NOT CONVERTED
		// void khtmlMouseMoveEvent(khtml::MouseMoveEvent* arg1); >>>> NOT CONVERTED
		// void khtmlMouseReleaseEvent(khtml::MouseReleaseEvent* arg1); >>>> NOT CONVERTED
		// void khtmlDrawContentsEvent(khtml::DrawContentsEvent* arg1); >>>> NOT CONVERTED
		// void setPageSecurity(KHTMLPart::PageSecurity arg1); >>>> NOT CONVERTED
		/// <remarks>
		///  Constructs a new KHTMLPart.
		///  KHTML basically consists of two objects: The KHTMLPart itself,
		///  holding the document data (DOM document), and the KHTMLView,
		///  derived from QScrollView, in which the document content is
		///  rendered in. You can specify two different parent objects for a
		///  KHTMLPart, one parent for the KHTMLPart document and on parent
		///  for the KHTMLView. If the second <code>parent</code> argument is null, then
		///  <code>parentWidget</code> is used as parent for both objects, the part and
		///  the view.
		///    </remarks>		<short>    Constructs a new KHTMLPart.</short>
		public KHTMLPart(QWidget parentWidget, QObject parent, KHTMLPart.GUIProfile prof) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart##$", "KHTMLPart(QWidget*, QObject*, KHTMLPart::GUIProfile)", typeof(void), typeof(QWidget), parentWidget, typeof(QObject), parent, typeof(KHTMLPart.GUIProfile), prof);
		}
		public KHTMLPart(QWidget parentWidget, QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart##", "KHTMLPart(QWidget*, QObject*)", typeof(void), typeof(QWidget), parentWidget, typeof(QObject), parent);
		}
		public KHTMLPart(QWidget parentWidget) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart#", "KHTMLPart(QWidget*)", typeof(void), typeof(QWidget), parentWidget);
		}
		public KHTMLPart() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart", "KHTMLPart()", typeof(void));
		}
		public KHTMLPart(KHTMLView view, QObject parent, KHTMLPart.GUIProfile prof) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart##$", "KHTMLPart(KHTMLView*, QObject*, KHTMLPart::GUIProfile)", typeof(void), typeof(KHTMLView), view, typeof(QObject), parent, typeof(KHTMLPart.GUIProfile), prof);
		}
		public KHTMLPart(KHTMLView view, QObject parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart##", "KHTMLPart(KHTMLView*, QObject*)", typeof(void), typeof(KHTMLView), view, typeof(QObject), parent);
		}
		public KHTMLPart(KHTMLView view) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KHTMLPart#", "KHTMLPart(KHTMLView*)", typeof(void), typeof(KHTMLView), view);
		}
		/// <remarks>
		///  Opens the specified URL <code>url.</code>
		///  Reimplemented from KParts.ReadOnlyPart.OpenUrl .
		///    </remarks>		<short>    Opens the specified URL <code>url.</code></short>
		[SmokeMethod("openUrl(const KUrl&)")]
		public override bool OpenUrl(KUrl url) {
			return (bool) interceptor.Invoke("openUrl#", "openUrl(const KUrl&)", typeof(bool), typeof(KUrl), url);
		}
		/// <remarks>
		///  Stops loading the document and kills all data requests (for images, etc.)
		///    </remarks>		<short>    Stops loading the document and kills all data requests (for images, etc.</short>
		[SmokeMethod("closeUrl()")]
		public override bool CloseUrl() {
			return (bool) interceptor.Invoke("closeUrl", "closeUrl()", typeof(bool));
		}
		/// <remarks>
		///  Called when a certain error situation (i.e. connection timed out) occurred.
		///  The default implementation either shows a KIO error dialog or loads a more
		///  verbose error description a as page, depending on the users configuration.
		///  <code>job</code> is the job that signaled the error situation
		///    </remarks>		<short>    Called when a certain error situation (i.</short>
		[SmokeMethod("showError(KJob*)")]
		public virtual void ShowError(KJob job) {
			interceptor.Invoke("showError#", "showError(KJob*)", typeof(void), typeof(KJob), job);
		}
		/// <remarks>
		///  Returns a reference to the DOM HTML document (for non-HTML documents, returns null)
		///    </remarks>		<short>    Returns a reference to the DOM HTML document (for non-HTML documents, returns null)    </short>
		public DOM.HTMLDocument HtmlDocument() {
			return (DOM.HTMLDocument) interceptor.Invoke("htmlDocument", "htmlDocument() const", typeof(DOM.HTMLDocument));
		}
		/// <remarks>
		///  Returns a reference to the DOM document.
		///    </remarks>		<short>    Returns a reference to the DOM document.</short>
		public DOM.Document Document() {
			return (DOM.Document) interceptor.Invoke("document", "document() const", typeof(DOM.Document));
		}
		/// <remarks>
		///  Returns the content of the source document.
		///    </remarks>		<short>    Returns the content of the source document.</short>
		public string DocumentSource() {
			return (string) interceptor.Invoke("documentSource", "documentSource() const", typeof(string));
		}
		/// <remarks>
		///  Returns the node that has the keyboard focus.
		///    </remarks>		<short>    Returns the node that has the keyboard focus.</short>
		public DOM.Node ActiveNode() {
			return (DOM.Node) interceptor.Invoke("activeNode", "activeNode() const", typeof(DOM.Node));
		}
		/// <remarks>
		///  Returns a pointer to the KParts.BrowserExtension.
		///    </remarks>		<short>    Returns a pointer to the KParts.BrowserExtension.</short>
		public new KParts.BrowserExtension BrowserExtension() {
			return (KParts.BrowserExtension) interceptor.Invoke("browserExtension", "browserExtension() const", typeof(KParts.BrowserExtension));
		}
		public KParts.BrowserHostExtension BrowserHostExtension() {
			return (KParts.BrowserHostExtension) interceptor.Invoke("browserHostExtension", "browserHostExtension() const", typeof(KParts.BrowserHostExtension));
		}
		/// <remarks>
		///  Returns a pointer to the HTML document's view.
		///    </remarks>		<short>    Returns a pointer to the HTML document's view.</short>
		public KHTMLView View() {
			return (KHTMLView) interceptor.Invoke("view", "view() const", typeof(KHTMLView));
		}
		/// <remarks>
		///  Returns the JavaScript interpreter the part is using. This method is
		///  mainly intended for applications which embed and extend the part and
		///  provides a mechanism for adding additional native objects to the
		///  interpreter (or removing the built-ins).
		///  One thing people using this method to add things to the interpreter must
		///  consider, is that when you start writing new content to the part, the
		///  interpreter is cleared. This includes both use of the
		///  begin( KUrl, int, int ) method, and the openUrl( KUrl )
		///  method. If you want your objects to have a longer lifespan, then you must
		///  retain a KJS.Object yourself to ensure that the reference count of your
		///  custom objects never reaches 0. You will also need to re-add your
		///  bindings every time this happens - one way to detect the need for this is
		///  to connect to the docCreated() signal, another is to reimplement the
		///  begin() method.
		///    </remarks>		<short>    Returns the JavaScript interpreter the part is using.</short>
		/// <remarks>
		///  Enable/disable statusbar messages.
		///  When this class wants to set the statusbar text, it emits
		///  setStatusBarText(string text)
		///  If you want to catch this for your own statusbar, note that it returns
		///  back a rich text string, starting with "<qt>".  This you need to
		///  either pass this into your own QLabel or to strip out the tags
		///  before passing it to QStatusBar.Message(string message)
		/// </remarks>		<short>    Enable/disable statusbar messages.</short>
		/// 		<see> Part.SetStatusBarText(</see>
		/// 		<see> const</see>
		/// 		<see> text</see>
		public void SetStatusMessagesEnabled(bool enable) {
			interceptor.Invoke("setStatusMessagesEnabled$", "setStatusMessagesEnabled(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Returns <code>true</code> if status messages are enabled.
		///    </remarks>		<short>    Returns <code>true</code> if status messages are enabled.</short>
		public bool StatusMessagesEnabled() {
			return (bool) interceptor.Invoke("statusMessagesEnabled", "statusMessagesEnabled() const", typeof(bool));
		}
		/// <remarks>
		///  Same as executeScript( string ) except with the Node parameter
		///  specifying the 'this' value.
		///    </remarks>		<short>    Same as executeScript( string ) except with the Node parameter  specifying the 'this' value.</short>
		public QVariant ExecuteScript(DOM.Node n, string script) {
			return (QVariant) interceptor.Invoke("executeScript#$", "executeScript(const DOM::Node&, const QString&)", typeof(QVariant), typeof(DOM.Node), n, typeof(string), script);
		}
		/// <remarks>
		///  Returns the java context of the applets. If no applet exists, 0 is returned.
		///    </remarks>		<short>    Returns the java context of the applets.</short>
		/// <remarks>
		///  Returns the java context of the applets. If no context exists yet, a
		///  new one is created.
		///    </remarks>		<short>    Returns the java context of the applets.</short>
		/// <remarks>
		///  Specifies whether images contained in the document should be loaded
		///  automatically or not.
		///  @note Request will be ignored if called before begin().
		///    </remarks>		<short>    Specifies whether images contained in the document should be loaded  automatically or not.</short>
		public void SetAutoloadImages(bool enable) {
			interceptor.Invoke("setAutoloadImages$", "setAutoloadImages(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Returns whether images contained in the document are loaded automatically
		///  or not.
		///  @note that the returned information is unrelieable as long as no begin()
		///  was called.
		///    </remarks>		<short>    Returns whether images contained in the document are loaded automatically  or not.</short>
		public bool AutoloadImages() {
			return (bool) interceptor.Invoke("autoloadImages", "autoloadImages() const", typeof(bool));
		}
		/// <remarks>
		///  Security option.
		///  Specify whether only file:/ or data:/ urls are allowed to be loaded without
		///  user confirmation by KHTML.
		///  ( for example referenced by stylesheets, images, scripts, subdocuments, embedded elements ).
		///  This option is mainly intended for enabling the "mail reader mode", where you load untrusted
		///  content with a file:/ url.
		///  Please note that enabling this option currently automatically disables Javascript,
		///  Java and Plugins support. This might change in the future if the security model
		///  is becoming more sophisticated, so don't rely on this behaviour.
		///  ( default <code>false</code> - everything is loaded unless forbidden by KApplication.AuthorizeURLAction).
		///    </remarks>		<short>    Security option.</short>
		public void SetOnlyLocalReferences(bool enable) {
			interceptor.Invoke("setOnlyLocalReferences$", "setOnlyLocalReferences(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Returns whether only file:/ or data:/ references are allowed
		///  to be loaded ( default <code>false</code> ).  See setOnlyLocalReferences.
		/// </remarks>		<short>    Returns whether only file:/ or data:/ references are allowed  to be loaded ( default <code>false</code> ).</short>
		public bool OnlyLocalReferences() {
			return (bool) interceptor.Invoke("onlyLocalReferences", "onlyLocalReferences() const", typeof(bool));
		}
		/// <remarks> Returns whether caret mode is on/off.
		///    </remarks>		<short>   Returns whether caret mode is on/off.</short>
		public bool IsCaretMode() {
			return (bool) interceptor.Invoke("isCaretMode", "isCaretMode() const", typeof(bool));
		}
		/// <remarks>
		///  Returns <code>true</code> if the document is editable, <code>false</code> otherwise.
		///    </remarks>		<short>    Returns <code>true</code> if the document is editable, <code>false</code> otherwise.</short>
		public bool IsEditable() {
			return (bool) interceptor.Invoke("isEditable", "isEditable() const", typeof(bool));
		}
		/// <remarks>
		///  Sets the caret to the given position.
		///  If the given location is invalid, it will snap to the nearest valid
		///  location. Immediately afterwards a <code>caretPositionChanged</code> signal
		///  containing the effective position is emitted
		/// <param> name="node" node to set to
		/// </param><param> name="offset" zero-based offset within the node
		/// </param><param> name="extendSelection" If <code>true</code>, a selection will be spanned from the
		/// 	last caret position to the given one. Otherwise, any existing selection
		/// 	will be deselected.
		///    </param></remarks>		<short>    Sets the caret to the given position.</short>
		public void SetCaretPosition(DOM.Node node, long offset, bool extendSelection) {
			interceptor.Invoke("setCaretPosition#$$", "setCaretPosition(DOM::Node, long, bool)", typeof(void), typeof(DOM.Node), node, typeof(long), offset, typeof(bool), extendSelection);
		}
		public void SetCaretPosition(DOM.Node node, long offset) {
			interceptor.Invoke("setCaretPosition#$", "setCaretPosition(DOM::Node, long)", typeof(void), typeof(DOM.Node), node, typeof(long), offset);
		}
		/// <remarks>
		///  Returns the current caret policy when the view is not focused.
		///    </remarks>		<short>    Returns the current caret policy when the view is not focused.</short>
		public KHTMLPart.CaretDisplayPolicy CaretDisplayPolicyNonFocused() {
			return (KHTMLPart.CaretDisplayPolicy) interceptor.Invoke("caretDisplayPolicyNonFocused", "caretDisplayPolicyNonFocused() const", typeof(KHTMLPart.CaretDisplayPolicy));
		}
		/// <remarks>
		///  Sets the caret display policy when the view is not focused.
		///  Whenever the caret is in use, this property determines how the
		///  caret should be displayed when the document view is not focused.
		///  The default policy is CaretInvisible.
		/// <param> name="policy" new display policy
		///    </param></remarks>		<short>    Sets the caret display policy when the view is not focused.</short>
		public void SetCaretDisplayPolicyNonFocused(KHTMLPart.CaretDisplayPolicy policy) {
			interceptor.Invoke("setCaretDisplayPolicyNonFocused$", "setCaretDisplayPolicyNonFocused(KHTMLPart::CaretDisplayPolicy)", typeof(void), typeof(KHTMLPart.CaretDisplayPolicy), policy);
		}
		public void EnableJScript(bool e) {
			interceptor.Invoke("enableJScript$", "enableJScript(bool)", typeof(void), typeof(bool), e);
		}
		public void EnableJava(bool e) {
			interceptor.Invoke("enableJava$", "enableJava(bool)", typeof(void), typeof(bool), e);
		}
		public void EnablePlugins(bool e) {
			interceptor.Invoke("enablePlugins$", "enablePlugins(bool)", typeof(void), typeof(bool), e);
		}
		public void AutoloadImages(bool e) {
			interceptor.Invoke("autoloadImages$", "autoloadImages(bool)", typeof(void), typeof(bool), e);
		}
		public void EnableMetaRefresh(bool e) {
			interceptor.Invoke("enableMetaRefresh$", "enableMetaRefresh(bool)", typeof(void), typeof(bool), e);
		}
		public bool SetCharset(string arg1, bool arg2) {
			return (bool) interceptor.Invoke("setCharset$$", "setCharset(const QString&, bool)", typeof(bool), typeof(string), arg1, typeof(bool), arg2);
		}
		public KUrl BaseURL() {
			return (KUrl) interceptor.Invoke("baseURL", "baseURL() const", typeof(KUrl));
		}
		public string BaseTarget() {
			return (string) interceptor.Invoke("baseTarget", "baseTarget() const", typeof(string));
		}
		/// <remarks>
		///  Returns the URL for the background Image (used by save background)
		///    </remarks>		<short>    Returns the URL for the background Image (used by save background)    </short>
		public KUrl BackgroundURL() {
			return (KUrl) interceptor.Invoke("backgroundURL", "backgroundURL() const", typeof(KUrl));
		}
		/// <remarks>
		///  Schedules a redirection after <code>delay</code> seconds.
		///    </remarks>		<short>    Schedules a redirection after <code>delay</code> seconds.</short>
		public void ScheduleRedirection(int delay, string url, bool lockHistory) {
			interceptor.Invoke("scheduleRedirection$$$", "scheduleRedirection(int, const QString&, bool)", typeof(void), typeof(int), delay, typeof(string), url, typeof(bool), lockHistory);
		}
		public void ScheduleRedirection(int delay, string url) {
			interceptor.Invoke("scheduleRedirection$$", "scheduleRedirection(int, const QString&)", typeof(void), typeof(int), delay, typeof(string), url);
		}
		/// <remarks>
		///  Clears the widget and prepares it for new content.
		///  If you want url() to return
		///  for example "file:/tmp/test.html", you can use the following code:
		///  <pre>
		///  view.Begin( KUrl("file:/tmp/test.html" ) );
		///  </pre>
		/// <param> name="url" is the url of the document to be displayed.  Even if you
		///  are generating the HTML on the fly, it may be useful to specify
		///  a directory so that any pixmaps are found.
		/// </param><param> name="xOffset" is the initial horizontal scrollbar value. Usually
		///  you don't want to use this.
		/// </param><param> name="yOffset" is the initial vertical scrollbar value. Usually
		///  you don't want to use this.
		/// </param> All child frames and the old document are removed if you call
		///  this method.
		///    </remarks>		<short>    Clears the widget and prepares it for new content.</short>
		[SmokeMethod("begin(const KUrl&, int, int)")]
		public virtual void Begin(KUrl url, int xOffset, int yOffset) {
			interceptor.Invoke("begin#$$", "begin(const KUrl&, int, int)", typeof(void), typeof(KUrl), url, typeof(int), xOffset, typeof(int), yOffset);
		}
		[SmokeMethod("begin(const KUrl&, int)")]
		public virtual void Begin(KUrl url, int xOffset) {
			interceptor.Invoke("begin#$", "begin(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), xOffset);
		}
		[SmokeMethod("begin(const KUrl&)")]
		public virtual void Begin(KUrl url) {
			interceptor.Invoke("begin#", "begin(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		[SmokeMethod("begin()")]
		public virtual void Begin() {
			interceptor.Invoke("begin", "begin()", typeof(void));
		}
		/// <remarks>
		///  Writes another part of the HTML code to the widget.
		///  You may call
		///  this function many times in sequence. But remember: The fewer calls
		///  you make, the faster the widget will be.
		///  The HTML code is send through a decoder which decodes the stream to
		///  Unicode.
		///  The <code>len</code> parameter is needed for streams encoded in utf-16,
		///  since these can have \\0 chars in them. In case the encoding
		///  you're using isn't utf-16, you can safely leave out the length
		///  parameter.
		///  Attention: Don't mix calls to write( string ) with calls
		///  to write( string ).
		///  The result might not be what you want.
		///    </remarks>		<short>    Writes another part of the HTML code to the widget.</short>
		[SmokeMethod("write(const char*, int)")]
		public virtual void Write(string str, int len) {
			interceptor.Invoke("write$$", "write(const char*, int)", typeof(void), typeof(string), str, typeof(int), len);
		}
		[SmokeMethod("write(const char*)")]
		public virtual void Write(string str) {
			interceptor.Invoke("write$", "write(const char*)", typeof(void), typeof(string), str);
		}
		/// <remarks>
		///  Call this after your last call to write().
		///    </remarks>		<short>    Call this after your last call to write().</short>
		[SmokeMethod("end()")]
		public virtual void End() {
			interceptor.Invoke("end", "end()", typeof(void));
		}
		/// <remarks>
		///  Paints the HTML page to a QPainter. See KHTMLView.Paint for details
		///    </remarks>		<short>    Paints the HTML page to a QPainter.</short>
		public void Paint(QPainter arg1, QRect arg2, int arg3, ref bool arg4) {
			StackItem[] stack = new StackItem[5];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(arg1);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(arg1);
#endif
#if DEBUG
			stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(arg2);
#else
			stack[2].s_class = (IntPtr) GCHandle.Alloc(arg2);
#endif
			stack[3].s_int = arg3;
			stack[4].s_bool = arg4;
			interceptor.Invoke("paint##$$", "paint(QPainter*, const QRect&, int, bool*)", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
			((GCHandle) stack[2].s_class).Free();
#endif
			arg4 = stack[4].s_bool;
			return;
		}
		public void Paint(QPainter arg1, QRect arg2, int arg3) {
			interceptor.Invoke("paint##$", "paint(QPainter*, const QRect&, int)", typeof(void), typeof(QPainter), arg1, typeof(QRect), arg2, typeof(int), arg3);
		}
		public void Paint(QPainter arg1, QRect arg2) {
			interceptor.Invoke("paint##", "paint(QPainter*, const QRect&)", typeof(void), typeof(QPainter), arg1, typeof(QRect), arg2);
		}
		/// <remarks>
		///  Sets the encoding the page uses.
		///  This can be different from the charset. The widget will try to reload the current page in the new
		///  encoding, if url() is not empty.
		///    </remarks>		<short>    Sets the encoding the page uses.</short>
		public bool SetEncoding(string name, bool arg2) {
			return (bool) interceptor.Invoke("setEncoding$$", "setEncoding(const QString&, bool)", typeof(bool), typeof(string), name, typeof(bool), arg2);
		}
		public bool SetEncoding(string name) {
			return (bool) interceptor.Invoke("setEncoding$", "setEncoding(const QString&)", typeof(bool), typeof(string), name);
		}
		/// <remarks>
		///  Sets a user defined style sheet to be used on top of the HTML 4
		///  default style sheet.
		///  This gives a wide range of possibilities to
		///  change the layout of the page.
		///  To have an effect this function has to be called after calling begin().
		///    </remarks>		<short>    Sets a user defined style sheet to be used on top of the HTML 4  default style sheet.</short>
		public void SetUserStyleSheet(KUrl url) {
			interceptor.Invoke("setUserStyleSheet#", "setUserStyleSheet(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		/// <remarks>
		///  Sets a user defined style sheet to be used on top of the HTML 4
		///  default style sheet.
		///  This gives a wide range of possibilities to
		///  change the layout of the page.
		///  To have an effect this function has to be called after calling begin().
		///    </remarks>		<short>    Sets a user defined style sheet to be used on top of the HTML 4  default style sheet.</short>
		public void SetUserStyleSheet(string styleSheet) {
			interceptor.Invoke("setUserStyleSheet$", "setUserStyleSheet(const QString&)", typeof(void), typeof(string), styleSheet);
		}
		/// <remarks>
		///  Sets the standard font style.
		/// <param> name="name" The font name to use for standard text.
		///    </param></remarks>		<short>    Sets the standard font style.</short>
		public void SetStandardFont(string name) {
			interceptor.Invoke("setStandardFont$", "setStandardFont(const QString&)", typeof(void), typeof(string), name);
		}
		/// <remarks>
		///  Sets the fixed font style.
		/// <param> name="name" The font name to use for fixed text, e.g.
		///  the <tt>&lt;pre&gt;</tt> tag.
		///    </param></remarks>		<short>    Sets the fixed font style.</short>
		public void SetFixedFont(string name) {
			interceptor.Invoke("setFixedFont$", "setFixedFont(const QString&)", typeof(void), typeof(string), name);
		}
		/// <remarks>
		///  Finds the anchor named <code>name.</code>
		///  If the anchor is found, the widget
		///  scrolls to the closest position. Returns <code>if</code> the anchor has
		///  been found.
		///    </remarks>		<short>    Finds the anchor named <code>name.</code></short>
		public bool GotoAnchor(string name) {
			return (bool) interceptor.Invoke("gotoAnchor$", "gotoAnchor(const QString&)", typeof(bool), typeof(string), name);
		}
		/// <remarks>
		///  Go to the next anchor
		///  This is useful to navigate from outside the navigator
		///    </remarks>		<short>    Go to the next anchor </short>
		public bool NextAnchor() {
			return (bool) interceptor.Invoke("nextAnchor", "nextAnchor()", typeof(bool));
		}
		/// <remarks>
		///  Go to previous anchor
		///    </remarks>		<short>    Go to previous anchor    </short>
		public bool PrevAnchor() {
			return (bool) interceptor.Invoke("prevAnchor", "prevAnchor()", typeof(bool));
		}
		/// <remarks>
		///  Sets the cursor to use when the cursor is on a link.
		///    </remarks>		<short>    Sets the cursor to use when the cursor is on a link.</short>
		public void SetURLCursor(QCursor c) {
			interceptor.Invoke("setURLCursor#", "setURLCursor(const QCursor&)", typeof(void), typeof(QCursor), c);
		}
		/// <remarks>
		///  Returns the cursor which is used when the cursor is on a link.
		///    </remarks>		<short>    Returns the cursor which is used when the cursor is on a link.</short>
		public QCursor UrlCursor() {
			return (QCursor) interceptor.Invoke("urlCursor", "urlCursor() const", typeof(QCursor));
		}
		/// <remarks>
		///  Starts a new search by popping up a dialog asking the user what he wants to
		///  search for.
		///    </remarks>		<short>    Starts a new search by popping up a dialog asking the user what he wants to  search for.</short>
		public void FindText() {
			interceptor.Invoke("findText", "findText()", typeof(void));
		}
		/// <remarks>
		///  Starts a new search, but bypasses the user dialog.
		/// <param> name="str" The string to search for.
		/// </param><param> name="options" Find options.
		/// </param><param> name="parent" Parent used for centering popups like "string not found".
		/// </param><param> name="findDialog" Optionally, you can supply your own dialog.
		///    </param></remarks>		<short>    Starts a new search, but bypasses the user dialog.</short>
		public void FindText(string str, long options, QWidget parent, KFindDialog findDialog) {
			interceptor.Invoke("findText$$##", "findText(const QString&, long, QWidget*, KFindDialog*)", typeof(void), typeof(string), str, typeof(long), options, typeof(QWidget), parent, typeof(KFindDialog), findDialog);
		}
		public void FindText(string str, long options, QWidget parent) {
			interceptor.Invoke("findText$$#", "findText(const QString&, long, QWidget*)", typeof(void), typeof(string), str, typeof(long), options, typeof(QWidget), parent);
		}
		public void FindText(string str, long options) {
			interceptor.Invoke("findText$$", "findText(const QString&, long)", typeof(void), typeof(string), str, typeof(long), options);
		}
		/// <remarks>
		///  Initiates a text search.
		///    </remarks>		<short>    Initiates a text search.</short>
		public void FindTextBegin() {
			interceptor.Invoke("findTextBegin", "findTextBegin()", typeof(void));
		}
		/// <remarks>
		///  Finds the next occurrence of a string set by <see cref="#findText"></see>
		/// <param> name="reverse" if <code>true</code>, revert seach direction (only if no find dialog is used)
		/// </param></remarks>		<return> <code>true</code> if a new match was found.
		///    </return>
		/// 		<short>    Finds the next occurrence of a string set by @ref findText() </short>
		public bool FindTextNext(bool reverse) {
			return (bool) interceptor.Invoke("findTextNext$", "findTextNext(bool)", typeof(bool), typeof(bool), reverse);
		}
		public bool FindTextNext() {
			return (bool) interceptor.Invoke("findTextNext", "findTextNext()", typeof(bool));
		}
		/// <remarks>
		///  Sets the Zoom factor. The value is given in percent, larger values mean a
		///  generally larger font and larger page contents.
		///  The given value should be in the range of 20..300, values outside that
		///  range are not guaranteed to work. A value of 100 will disable all zooming
		///  and show the page with the sizes determined via the given lengths in the
		///  stylesheets.
		///    </remarks>		<short>    Sets the Zoom factor.</short>
		public void SetZoomFactor(int percent) {
			interceptor.Invoke("setZoomFactor$", "setZoomFactor(int)", typeof(void), typeof(int), percent);
		}
		/// <remarks>
		///  Returns the current zoom factor.
		///    </remarks>		<short>    Returns the current zoom factor.</short>
		public int ZoomFactor() {
			return (int) interceptor.Invoke("zoomFactor", "zoomFactor() const", typeof(int));
		}
		/// <remarks>
		///  Sets the scale factor to be applied to fonts. The value is given in percent, 
		///  larger values mean generally larger fonts.
		///  The given value should be in the range of 20..300, values outside that
		///  range are not guaranteed to work. A value of 100 will disable all scaling of font sizes
		///  and show the page with the sizes determined via the given lengths in the
		///  stylesheets.
		///    </remarks>		<short>    Sets the scale factor to be applied to fonts.</short>
		public void SetFontScaleFactor(int percent) {
			interceptor.Invoke("setFontScaleFactor$", "setFontScaleFactor(int)", typeof(void), typeof(int), percent);
		}
		/// <remarks>
		///  Returns the current font scale factor.
		///    </remarks>		<short>    Returns the current font scale factor.</short>
		public int FontScaleFactor() {
			return (int) interceptor.Invoke("fontScaleFactor", "fontScaleFactor() const", typeof(int));
		}
		/// <remarks>
		///  Returns the text the user has marked.
		///    </remarks>		<short>    Returns the text the user has marked.</short>
		[SmokeMethod("selectedText() const")]
		public virtual string SelectedText() {
			return (string) interceptor.Invoke("selectedText", "selectedText() const", typeof(string));
		}
		/// <remarks>
		///  Return the text the user has marked.  This is guaranteed to be valid xml,
		///  and to contain the \<html> and \<body> tags.
		///  FIXME probably should make for 4.0 ?
		///    </remarks>		<short>    Return the text the user has marked.</short>
		public string SelectedTextAsHTML() {
			return (string) interceptor.Invoke("selectedTextAsHTML", "selectedTextAsHTML() const", typeof(string));
		}
		/// <remarks>
		///  Returns the selected part of the HTML.
		///    </remarks>		<short>    Returns the selected part of the HTML.</short>
		public DOM.Range Selection() {
			return (DOM.Range) interceptor.Invoke("selection", "selection() const", typeof(DOM.Range));
		}
		/// <remarks>
		///  Returns the selected part of the HTML by returning the starting and end
		///  position.
		///  If there is no selection, both nodes and offsets are equal.
		/// <param> name="startNode" returns node selection starts in
		/// </param><param> name="startOffset" returns offset within starting node
		/// </param><param> name="endNode" returns node selection ends in
		/// </param><param> name="endOffset" returns offset within end node.
		///    </param></remarks>		<short>    Returns the selected part of the HTML by returning the starting and end  position.</short>
		public void Selection(DOM.Node startNode, long startOffset, DOM.Node endNode, long endOffset) {
			interceptor.Invoke("selection#$#$", "selection(DOM::Node&, long&, DOM::Node&, long&) const", typeof(void), typeof(DOM.Node), startNode, typeof(long), startOffset, typeof(DOM.Node), endNode, typeof(long), endOffset);
		}
		/// <remarks>
		///  Sets the current selection.
		///    </remarks>		<short>    Sets the current selection.</short>
		public void SetSelection(DOM.Range arg1) {
			interceptor.Invoke("setSelection#", "setSelection(const DOM::Range&)", typeof(void), typeof(DOM.Range), arg1);
		}
		/// <remarks>
		///  Has the user selected anything?
		///   Call selectedText() to
		///  retrieve the selected text.
		/// </remarks>		<return> <code>true</code> if there is text selected.
		///    </return>
		/// 		<short>    Has the user selected anything? </short>
		public bool HasSelection() {
			return (bool) interceptor.Invoke("hasSelection", "hasSelection() const", typeof(bool));
		}
		/// <remarks>
		///  Marks all text in the document as selected.
		///    </remarks>		<short>    Marks all text in the document as selected.</short>
		public void SelectAll() {
			interceptor.Invoke("selectAll", "selectAll()", typeof(void));
		}
		/// <remarks>
		///  Convenience method to show the document's view.
		///  Equivalent to widget().Show() or view().Show() .
		///    </remarks>		<short>    Convenience method to show the document's view.</short>
		public void Show() {
			interceptor.Invoke("show", "show()", typeof(void));
		}
		/// <remarks>
		///  Convenience method to hide the document's view.
		///  Equivalent to widget().Hide() or view().Hide().
		///    </remarks>		<short>    Convenience method to hide the document's view.</short>
		public void Hide() {
			interceptor.Invoke("hide", "hide()", typeof(void));
		}
		/// <remarks>
		///  Returns a reference to the partmanager instance which
		///  manages html frame objects.
		///    </remarks>		<short>    Returns a reference to the partmanager instance which  manages html frame objects.</short>
		public KParts.PartManager PartManager() {
			return (KParts.PartManager) interceptor.Invoke("partManager", "partManager()", typeof(KParts.PartManager));
		}
		/// <remarks>
		///  Saves the KHTMLPart's complete state (including child frame
		///  objects) to the provided QDataStream.
		///  This is called from the saveState() method of the
		///  browserExtension().
		///    </remarks>		<short>    Saves the KHTMLPart's complete state (including child frame  objects) to the provided QDataStream.</short>
		[SmokeMethod("saveState(QDataStream&)")]
		public virtual void SaveState(QDataStream stream) {
			interceptor.Invoke("saveState#", "saveState(QDataStream&)", typeof(void), typeof(QDataStream), stream);
		}
		/// <remarks>
		///  Restores the KHTMLPart's previously saved state (including
		///  child frame objects) from the provided QDataStream.
		///  This is called from the restoreState() method of the
		///  browserExtension() .
		/// </remarks>		<short>    Restores the KHTMLPart's previously saved state (including  child frame objects) from the provided QDataStream.</short>
		/// 		<see> saveState</see>
		[SmokeMethod("restoreState(QDataStream&)")]
		public virtual void RestoreState(QDataStream stream) {
			interceptor.Invoke("restoreState#", "restoreState(QDataStream&)", typeof(void), typeof(QDataStream), stream);
		}
		/// <remarks>
		///  Returns the <code>Node</code> currently under the mouse.
		///  The returned node may be a shared node (e. g. an \<area> node if the
		///  mouse is hovering over an image map).
		///    </remarks>		<short>    Returns the <code>Node</code> currently under the mouse.</short>
		public DOM.Node NodeUnderMouse() {
			return (DOM.Node) interceptor.Invoke("nodeUnderMouse", "nodeUnderMouse() const", typeof(DOM.Node));
		}
		/// <remarks>
		///  Returns the <code>Node</code> currently under the mouse that is not shared.
		///  The returned node is always the node that is physically under the mouse
		///  pointer (irrespective of logically overlying elements like, e. g.,
		///  \<area> on image maps).
		///    </remarks>		<short>    Returns the <code>Node</code> currently under the mouse that is not shared.</short>
		public DOM.Node NonSharedNodeUnderMouse() {
			return (DOM.Node) interceptor.Invoke("nonSharedNodeUnderMouse", "nonSharedNodeUnderMouse() const", typeof(DOM.Node));
		}
		/// <remarks>
		///    </remarks>		<short>   </short>
		public KHTMLSettings Settings() {
			return (KHTMLSettings) interceptor.Invoke("settings", "settings() const", typeof(KHTMLSettings));
		}
		/// <remarks>
		///  Returns a pointer to the parent KHTMLPart if the part is a frame
		///  in an HTML frameset.
		///   Returns null otherwise.
		///    </remarks>		<short>    Returns a pointer to the parent KHTMLPart if the part is a frame  in an HTML frameset.</short>
		public KHTMLPart ParentPart() {
			return (KHTMLPart) interceptor.Invoke("parentPart", "parentPart()", typeof(KHTMLPart));
		}
		/// <remarks>
		///  Returns a list of names of all frame (including iframe) objects of
		///  the current document. Note that this method is not working recursively
		///  for sub-frames.
		///    </remarks>		<short>    Returns a list of names of all frame (including iframe) objects of  the current document.</short>
		public List<string> FrameNames() {
			return (List<string>) interceptor.Invoke("frameNames", "frameNames() const", typeof(List<string>));
		}
		public List<KParts.ReadOnlyPart> Frames() {
			return (List<KParts.ReadOnlyPart>) interceptor.Invoke("frames", "frames() const", typeof(List<KParts.ReadOnlyPart>));
		}
		/// <remarks>
		///  Finds a frame by name. Returns null if frame can't be found.
		///    </remarks>		<short>    Finds a frame by name.</short>
		public KHTMLPart FindFrame(string f) {
			return (KHTMLPart) interceptor.Invoke("findFrame$", "findFrame(const QString&)", typeof(KHTMLPart), typeof(string), f);
		}
		/// <remarks>
		///  Recursively finds the part containing the frame with name <code>f</code>
		///  and checks if it is accessible by <code>callingPart</code>
		///  Returns null if no suitable frame can't be found.
		///  Returns parent part if a suitable frame was found and
		///  frame info in <code>childFrame</code>
		///    </remarks>		<short>    Recursively finds the part containing the frame with name <code>f</code>  and checks if it is accessible by <code>callingPart</code>  Returns 0L if no suitable frame can't be found.</short>
		public KHTMLPart FindFrameParent(KParts.ReadOnlyPart callingPart, string f) {
			return (KHTMLPart) interceptor.Invoke("findFrameParent#$", "findFrameParent(KParts::ReadOnlyPart*, const QString&)", typeof(KHTMLPart), typeof(KParts.ReadOnlyPart), callingPart, typeof(string), f);
		}
		/// <remarks>
		///  Return the current frame (the one that has focus)
		///  Not necessarily a direct child of ours, framesets can be nested.
		///  Returns "this" if this part isn't a frameset.
		///    </remarks>		<short>    Return the current frame (the one that has focus)  Not necessarily a direct child of ours, framesets can be nested.</short>
		public KParts.ReadOnlyPart CurrentFrame() {
			return (KParts.ReadOnlyPart) interceptor.Invoke("currentFrame", "currentFrame() const", typeof(KParts.ReadOnlyPart));
		}
		/// <remarks>
		///  Returns whether a frame with the specified name is exists or not.
		///  In contrary to the findFrame method this one also returns <code>true</code>
		///  if the frame is defined but no displaying component has been
		///  found/loaded, yet.
		///    </remarks>		<short>    Returns whether a frame with the specified name is exists or not.</short>
		public bool FrameExists(string frameName) {
			return (bool) interceptor.Invoke("frameExists$", "frameExists(const QString&)", typeof(bool), typeof(string), frameName);
		}
		/// <remarks>
		///  Returns child frame framePart its script interpreter
		///    </remarks>		<short>    Returns child frame framePart its script interpreter    </short>
		/// <remarks>
		///  Finds a frame by name. Returns null if frame can't be found.
		///    </remarks>		<short>    Finds a frame by name.</short>
		public KParts.ReadOnlyPart FindFramePart(string f) {
			return (KParts.ReadOnlyPart) interceptor.Invoke("findFramePart$", "findFramePart(const QString&)", typeof(KParts.ReadOnlyPart), typeof(string), f);
		}
		/// <remarks>
		///  Called by KJS.
		///  Sets the StatusBarText assigned
		///  via window.status
		///    </remarks>		<short>    Called by KJS.</short>
		public void SetJSStatusBarText(string text) {
			interceptor.Invoke("setJSStatusBarText$", "setJSStatusBarText(const QString&)", typeof(void), typeof(string), text);
		}
		/// <remarks>
		///  Called by KJS.
		///  Sets the DefaultStatusBarText assigned
		///  via window.defaultStatus
		///    </remarks>		<short>    Called by KJS.</short>
		public void SetJSDefaultStatusBarText(string text) {
			interceptor.Invoke("setJSDefaultStatusBarText$", "setJSDefaultStatusBarText(const QString&)", typeof(void), typeof(string), text);
		}
		/// <remarks>
		///  Called by KJS.
		///  Returns the StatusBarText assigned
		///  via window.status
		///    </remarks>		<short>    Called by KJS.</short>
		public string JsStatusBarText() {
			return (string) interceptor.Invoke("jsStatusBarText", "jsStatusBarText() const", typeof(string));
		}
		/// <remarks>
		///  Called by KJS.
		///  Returns the DefaultStatusBarText assigned
		///  via window.defaultStatus
		///    </remarks>		<short>    Called by KJS.</short>
		public string JsDefaultStatusBarText() {
			return (string) interceptor.Invoke("jsDefaultStatusBarText", "jsDefaultStatusBarText() const", typeof(string));
		}
		/// <remarks>
		///  Referrer used for links in this page.
		///    </remarks>		<short>    Referrer used for links in this page.</short>
		public string Referrer() {
			return (string) interceptor.Invoke("referrer", "referrer() const", typeof(string));
		}
		/// <remarks>
		///  Referrer used to obtain this page.
		///    </remarks>		<short>    Referrer used to obtain this page.</short>
		public string PageReferrer() {
			return (string) interceptor.Invoke("pageReferrer", "pageReferrer() const", typeof(string));
		}
		/// <remarks>
		///  Loads a style sheet into the stylesheet cache.
		///    </remarks>		<short>    Loads a style sheet into the stylesheet cache.</short>
		public void PreloadStyleSheet(string url, string stylesheet) {
			interceptor.Invoke("preloadStyleSheet$$", "preloadStyleSheet(const QString&, const QString&)", typeof(void), typeof(string), url, typeof(string), stylesheet);
		}
		/// <remarks>
		///  Loads a script into the script cache.
		///    </remarks>		<short>    Loads a script into the script cache.</short>
		public void PreloadScript(string url, string script) {
			interceptor.Invoke("preloadScript$$", "preloadScript(const QString&, const QString&)", typeof(void), typeof(string), url, typeof(string), script);
		}
		/// <remarks>
		///    </remarks>		<short>   </short>
		public bool Restored() {
			return (bool) interceptor.Invoke("restored", "restored() const", typeof(bool));
		}
		/// <remarks>
		///  Determine if signal should be emitted before, instead or never when a
		///  submitForm() happens.
		///  ### KDE4 remove me
		///    </remarks>		<short>    Determine if signal should be emitted before, instead or never when a  submitForm() happens.</short>
		public void SetFormNotification(KHTMLPart.FormNotification fn) {
			interceptor.Invoke("setFormNotification$", "setFormNotification(KHTMLPart::FormNotification)", typeof(void), typeof(KHTMLPart.FormNotification), fn);
		}
		/// <remarks>
		///  Determine if signal should be emitted before, instead or never when a
		///  submitForm() happens.
		///  ### KDE4 remove me
		///    </remarks>		<short>    Determine if signal should be emitted before, instead or never when a  submitForm() happens.</short>
		public KHTMLPart.FormNotification formNotification() {
			return (KHTMLPart.FormNotification) interceptor.Invoke("formNotification", "formNotification() const", typeof(KHTMLPart.FormNotification));
		}
		/// <remarks>
		///  Returns the toplevel (origin) URL of this document, even if this
		///  part is a frame or an iframe.
		/// </remarks>		<return> the actual original url.
		///    </return>
		/// 		<short>    Returns the toplevel (origin) URL of this document, even if this  part is a frame or an iframe.</short>
		public KUrl ToplevelURL() {
			return (KUrl) interceptor.Invoke("toplevelURL", "toplevelURL()", typeof(KUrl));
		}
		/// <remarks>
		///  Shows or hides the suppressed popup indicator
		///    </remarks>		<short>    Shows or hides the suppressed popup indicator    </short>
		public void SetSuppressedPopupIndicator(bool enable, KHTMLPart originPart) {
			interceptor.Invoke("setSuppressedPopupIndicator$#", "setSuppressedPopupIndicator(bool, KHTMLPart*)", typeof(void), typeof(bool), enable, typeof(KHTMLPart), originPart);
		}
		/// <remarks>
		///    </remarks>		<short>   </short>
		public bool InProgress() {
			return (bool) interceptor.Invoke("inProgress", "inProgress() const", typeof(bool));
		}
		/// <remarks>
		///  Sets the focused node of the document to the specified node. If the node is a form control, the control will
		///  receive focus in the same way that it would if the user had clicked on it or tabbed to it with the keyboard. For
		///  most other types of elements, there is no visual indication of whether or not they are focused.
		///  See activeNode
		/// <param> name="node" The node to focus
		///    </param></remarks>		<short>    Sets the focused node of the document to the specified node.</short>
		[Q_SLOT("void setActiveNode(const DOM::Node&)")]
		public void SetActiveNode(DOM.Node node) {
			interceptor.Invoke("setActiveNode#", "setActiveNode(const DOM::Node&)", typeof(void), typeof(DOM.Node), node);
		}
		/// <remarks>
		///  Stops all animated images on the current and child pages
		///    </remarks>		<short>    Stops all animated images on the current and child pages    </short>
		[Q_SLOT("void stopAnimations()")]
		public void StopAnimations() {
			interceptor.Invoke("stopAnimations", "stopAnimations()", typeof(void));
		}
		/// <remarks>
		///  Enables/disables caret mode.
		///  Enabling caret mode displays a caret which can be used to navigate
		///  the document using the keyboard only. Caret mode is switched off by
		///  default.
		/// <param> name="enable" <code>true</code> to enable, <code>false</code> to disable caret mode.
		///    </param></remarks>		<short>    Enables/disables caret mode.</short>
		[Q_SLOT("void setCaretMode(bool)")]
		public void SetCaretMode(bool enable) {
			interceptor.Invoke("setCaretMode$", "setCaretMode(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Makes the document editable.
		///  Setting this property to <code>true</code> makes the document, and its
		///  subdocuments (such as frames, iframes, objects) editable as a whole.
		///  FIXME: insert more information about navigation, features etc. as seen fit
		/// <param> name="enable" <code>true</code> to set document editable, <code>false</code> to set it
		/// 	read-only.
		///    </param></remarks>		<short>    Makes the document editable.</short>
		[Q_SLOT("void setEditable(bool)")]
		public void SetEditable(bool enable) {
			interceptor.Invoke("setEditable$", "setEditable(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Sets the visibility of the caret.
		///  This methods displays or hides the caret regardless of the current
		///  caret display policy (see setCaretDisplayNonFocused), and regardless
		///  of focus.
		///  The caret will be shown/hidden only under at least one of
		///  the following conditions:
		/// 
		/// <li>
		/// the document is editable
		/// </li>
		/// 
		/// <li>
		/// the document is in caret mode
		/// </li>
		/// 
		/// <li>
		/// the document's currently focused element is editable
		/// </li>
		/// <param> name="show" <code>true</code> to make visible, <code>false</code> to hide.
		///    </param></remarks>		<short>    Sets the visibility of the caret.</short>
		[Q_SLOT("void setCaretVisible(bool)")]
		public void SetCaretVisible(bool show) {
			interceptor.Invoke("setCaretVisible$", "setCaretVisible(bool)", typeof(void), typeof(bool), show);
		}
		[Q_SLOT("void submitFormProxy(const char*, const QString&, const QByteArray&, const QString&, const QString&, const QString&)")]
		public void SubmitFormProxy(string action, string url, QByteArray formData, string target, string contentType, string boundary) {
			interceptor.Invoke("submitFormProxy$$#$$$", "submitFormProxy(const char*, const QString&, const QByteArray&, const QString&, const QString&, const QString&)", typeof(void), typeof(string), action, typeof(string), url, typeof(QByteArray), formData, typeof(string), target, typeof(string), contentType, typeof(string), boundary);
		}
		[Q_SLOT("void submitFormProxy(const char*, const QString&, const QByteArray&, const QString&, const QString&)")]
		public void SubmitFormProxy(string action, string url, QByteArray formData, string target, string contentType) {
			interceptor.Invoke("submitFormProxy$$#$$", "submitFormProxy(const char*, const QString&, const QByteArray&, const QString&, const QString&)", typeof(void), typeof(string), action, typeof(string), url, typeof(QByteArray), formData, typeof(string), target, typeof(string), contentType);
		}
		[Q_SLOT("void submitFormProxy(const char*, const QString&, const QByteArray&, const QString&)")]
		public void SubmitFormProxy(string action, string url, QByteArray formData, string target) {
			interceptor.Invoke("submitFormProxy$$#$", "submitFormProxy(const char*, const QString&, const QByteArray&, const QString&)", typeof(void), typeof(string), action, typeof(string), url, typeof(QByteArray), formData, typeof(string), target);
		}
		/// <remarks>
		///  returns a KUrl object for the given url. Use when
		///  you know what you're doing.
		///    </remarks>		<short>    returns a KUrl object for the given url.</short>
		protected KUrl CompleteURL(string url) {
			return (KUrl) interceptor.Invoke("completeURL$", "completeURL(const QString&)", typeof(KUrl), typeof(string), url);
		}
		/// <remarks>
		///  presents a detailed error message to the user.
		///  <code>errorCode</code> kio error code, eg KIO.ERR_SERVER_TIMEOUT.
		///  <code>text</code> kio additional information text.
		///  <code>url</code> the url that triggered the error.
		///    </remarks>		<short>    presents a detailed error message to the user.</short>
		protected void HtmlError(int errorCode, string text, KUrl reqUrl) {
			interceptor.Invoke("htmlError$$#", "htmlError(int, const QString&, const KUrl&)", typeof(void), typeof(int), errorCode, typeof(string), text, typeof(KUrl), reqUrl);
		}
		[SmokeMethod("customEvent(QEvent*)")]
		protected override void CustomEvent(QEvent arg1) {
			interceptor.Invoke("customEvent#", "customEvent(QEvent*)", typeof(void), typeof(QEvent), arg1);
		}
		/// <remarks>
		///  Eventhandler of the khtml.MousePressEvent.
		///    </remarks>		<short>    Eventhandler of the khtml.MousePressEvent.</short>
		/// <remarks>
		///  Eventhandler for the khtml.MouseDoubleClickEvent.
		///    </remarks>		<short>    Eventhandler for the khtml.MouseDoubleClickEvent.</short>
		/// <remarks>
		///  Eventhandler for the khtml.MouseMouseMoveEvent.
		///    </remarks>		<short>    Eventhandler for the khtml.MouseMouseMoveEvent.</short>
		/// <remarks>
		///  Eventhandler for the khtml.MouseMouseReleaseEvent.
		///    </remarks>		<short>    Eventhandler for the khtml.MouseMouseReleaseEvent.</short>
		/// <remarks>
		///  Eventhandler for the khtml.DrawContentsEvent.
		///    </remarks>		<short>    Eventhandler for the khtml.DrawContentsEvent.</short>
		/// <remarks>
		///  Internal reimplementation of KParts.Part.GuiActivateEvent .
		///    </remarks>		<short>    Internal reimplementation of KParts.Part.GuiActivateEvent .</short>
		[SmokeMethod("guiActivateEvent(KParts::GUIActivateEvent*)")]
		protected override void GuiActivateEvent(KParts.GUIActivateEvent arg1) {
			interceptor.Invoke("guiActivateEvent#", "guiActivateEvent(KParts::GUIActivateEvent*)", typeof(void), typeof(KParts.GUIActivateEvent), arg1);
		}
		/// <remarks>
		///  Internal empty reimplementation of KParts.ReadOnlyPart.OpenFile .
		///    </remarks>		<short>    Internal empty reimplementation of KParts.ReadOnlyPart.OpenFile .</short>
		[SmokeMethod("openFile()")]
		protected override bool OpenFile() {
			return (bool) interceptor.Invoke("openFile", "openFile()", typeof(bool));
		}
		[SmokeMethod("urlSelected(const QString&, int, int, const QString&, const KParts::OpenUrlArguments&, const KParts::BrowserArguments&)")]
		protected virtual bool UrlSelected(string url, int button, int state, string _target, KParts.OpenUrlArguments args, KParts.BrowserArguments browserArgs) {
			return (bool) interceptor.Invoke("urlSelected$$$$##", "urlSelected(const QString&, int, int, const QString&, const KParts::OpenUrlArguments&, const KParts::BrowserArguments&)", typeof(bool), typeof(string), url, typeof(int), button, typeof(int), state, typeof(string), _target, typeof(KParts.OpenUrlArguments), args, typeof(KParts.BrowserArguments), browserArgs);
		}
		[SmokeMethod("urlSelected(const QString&, int, int, const QString&, const KParts::OpenUrlArguments&)")]
		protected virtual bool UrlSelected(string url, int button, int state, string _target, KParts.OpenUrlArguments args) {
			return (bool) interceptor.Invoke("urlSelected$$$$#", "urlSelected(const QString&, int, int, const QString&, const KParts::OpenUrlArguments&)", typeof(bool), typeof(string), url, typeof(int), button, typeof(int), state, typeof(string), _target, typeof(KParts.OpenUrlArguments), args);
		}
		[SmokeMethod("urlSelected(const QString&, int, int, const QString&)")]
		protected virtual bool UrlSelected(string url, int button, int state, string _target) {
			return (bool) interceptor.Invoke("urlSelected$$$$", "urlSelected(const QString&, int, int, const QString&)", typeof(bool), typeof(string), url, typeof(int), button, typeof(int), state, typeof(string), _target);
		}
		/// <remarks>
		///  This method is called when a new embedded object (include html frames) is to be created.
		///  Reimplement it if you want to add support for certain embeddable objects without registering
		///  them in the KDE wide registry system (KSyCoCa) . Another reason for re-implementing this
		///  method could be if you want to derive from KTHMLPart and also want all html frame objects
		///  to be a object of your derived type, in which case you should return a new instance for
		///  the mimetype 'text/html' .
		///    </remarks>		<short>    This method is called when a new embedded object (include html frames) is to be created.</short>
		[SmokeMethod("createPart(QWidget*, QObject*, const QString&, QString&, QStringList&, const QStringList&)")]
		protected virtual KParts.ReadOnlyPart CreatePart(QWidget parentWidget, QObject parent, string mimetype, StringBuilder serviceName, List<string> serviceTypes, List<string> arg6) {
			return (KParts.ReadOnlyPart) interceptor.Invoke("createPart##$$??", "createPart(QWidget*, QObject*, const QString&, QString&, QStringList&, const QStringList&)", typeof(KParts.ReadOnlyPart), typeof(QWidget), parentWidget, typeof(QObject), parent, typeof(string), mimetype, typeof(StringBuilder), serviceName, typeof(List<string>), serviceTypes, typeof(List<string>), arg6);
		}
		protected bool PluginPageQuestionAsked(string mimetype) {
			return (bool) interceptor.Invoke("pluginPageQuestionAsked$", "pluginPageQuestionAsked(const QString&) const", typeof(bool), typeof(string), mimetype);
		}
		protected void SetPluginPageQuestionAsked(string mimetype) {
			interceptor.Invoke("setPluginPageQuestionAsked$", "setPluginPageQuestionAsked(const QString&)", typeof(void), typeof(string), mimetype);
		}
		/// <remarks>
		///  Implements the streaming API of KParts.ReadOnlyPart.
		///    </remarks>		<short>    Implements the streaming API of KParts.ReadOnlyPart.</short>
		[SmokeMethod("doOpenStream(const QString&)")]
		protected virtual bool DoOpenStream(string mimeType) {
			return (bool) interceptor.Invoke("doOpenStream$", "doOpenStream(const QString&)", typeof(bool), typeof(string), mimeType);
		}
		/// <remarks>
		///  Implements the streaming API of KParts.ReadOnlyPart.
		///    </remarks>		<short>    Implements the streaming API of KParts.ReadOnlyPart.</short>
		[SmokeMethod("doWriteStream(const QByteArray&)")]
		protected virtual bool DoWriteStream(QByteArray data) {
			return (bool) interceptor.Invoke("doWriteStream#", "doWriteStream(const QByteArray&)", typeof(bool), typeof(QByteArray), data);
		}
		/// <remarks>
		///  Implements the streaming API of KParts.ReadOnlyPart.
		///    </remarks>		<short>    Implements the streaming API of KParts.ReadOnlyPart.</short>
		[SmokeMethod("doCloseStream()")]
		protected virtual bool DoCloseStream() {
			return (bool) interceptor.Invoke("doCloseStream", "doCloseStream()", typeof(bool));
		}
		/// <remarks>
		///  Hook for adding code before a job is started.
		///  This can be used to add metadata, like job.AddMetaData("PropagateHttpHeader", "true")
		///  to get the HTTP headers.
		///    </remarks>		<short>    Hook for adding code before a job is started.</short>
		[SmokeMethod("startingJob(KIO::Job*)")]
		protected virtual void StartingJob(KIO.Job arg1) {
			interceptor.Invoke("startingJob#", "startingJob(KIO::Job*)", typeof(void), typeof(KIO.Job), arg1);
		}
		/// <remarks>
		///  Called when the job downloading the page is finished.
		///  Can be reimplemented, for instance to get metadata out of the job,
		///  but make sure to call KHTMLPart.SlotFinished() too.
		///    </remarks>		<short>    Called when the job downloading the page is finished.</short>
		[Q_SLOT("void slotFinished(KJob*)")]
		[SmokeMethod("slotFinished(KJob*)")]
		protected virtual void SlotFinished(KJob arg1) {
			interceptor.Invoke("slotFinished#", "slotFinished(KJob*)", typeof(void), typeof(KJob), arg1);
		}
		~KHTMLPart() {
			interceptor.Invoke("~KHTMLPart", "~KHTMLPart()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KHTMLPart", "~KHTMLPart()", typeof(void));
		}
		protected new IKHTMLPartSignals Emit {
			get { return (IKHTMLPartSignals) Q_EMIT; }
		}
	}

	public interface IKHTMLPartSignals : KParts.IReadOnlyPartSignals {
		/// <remarks>
		///  Emitted if the cursor is moved over an URL.
		///    </remarks>		<short>    Emitted if the cursor is moved over an URL.</short>
		[Q_SIGNAL("void onURL(const QString&)")]
		void OnURL(string url);
		/// <remarks>
		///  Emitted when the user clicks the right mouse button on the document.
		///    </remarks>		<short>    Emitted when the user clicks the right mouse button on the document.</short>
		[Q_SIGNAL("void popupMenu(const QString&, const QPoint&)")]
		void PopupMenu(string url, QPoint point);
		/// <remarks>
		///  This signal is emitted when the selection changes.
		///    </remarks>		<short>    This signal is emitted when the selection changes.</short>
		[Q_SIGNAL("void selectionChanged()")]
		void SelectionChanged();
		/// <remarks>
		///  This signal is emitted when an element retrieves the
		///  keyboard focus. Note that the signal argument can be
		///  a null node if no element is active, meaning a node
		///  has explicitly been deactivated without a new one
		///  becoming active.
		///    </remarks>		<short>    This signal is emitted when an element retrieves the  keyboard focus.</short>
		[Q_SIGNAL("void nodeActivated(const DOM::Node&)")]
		void NodeActivated(DOM.Node arg1);
		/// <remarks>
		///   void docCreated();
		///   /*
		///  This signal is emitted whenever the caret position has been changed.
		///  The signal transmits the position the DOM.Range way, the node and
		///  the zero-based offset within this node.
		/// <param> name="node" node which the caret is in. This can be null if the caret
		/// 	has been deactivated.
		/// </param><param> name="offset" offset within the node. If the node is null, the offset
		/// 	is meaningless.
		///    </param></remarks>		<short>   </short>
		[Q_SIGNAL("void caretPositionChanged(const DOM::Node&, long)")]
		void CaretPositionChanged(DOM.Node node, long offset);
		/// <remarks>
		///  If form notification is on, this will be emitted either for a form
		///  submit or before the form submit according to the setting.
		///  ### KDE4 remove me
		///    </remarks>		<short>    If form notification is on, this will be emitted either for a form  submit or before the form submit according to the setting.</short>
		[Q_SIGNAL("void formSubmitNotification(const char*, const QString&, const QByteArray&, const QString&, const QString&, const QString&)")]
		void FormSubmitNotification(string action, string url, QByteArray formData, string target, string contentType, string boundary);
		/// <remarks>
		///  Emitted whenever the configuration has changed
		///    </remarks>		<short>    Emitted whenever the configuration has changed    </short>
		[Q_SIGNAL("void configurationChanged()")]
		void ConfigurationChanged();
	}
}
