//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Collections.Generic;

	/// <remarks>
	///  This widget works as a network transparent filebrowser. You specify a URL
	///  to display and this url will be loaded via KDirLister. The user can
	///  browse through directories, highlight and select files, delete or rename
	///  files.
	///  It supports different views, e.g. a detailed view (see KFileDetailView),
	///  a simple icon view (see KFileIconView), a combination of two views,
	///  separating directories and files ( KCombiView).
	///  Additionally, a preview view is available (see KFilePreview), which can
	///  show either a simple or detailed view and additionally a preview widget
	///  (see setPreviewWidget()). KImageFilePreview is one implementation
	///  of a preview widget, that displays previews for all supported filetypes
	///  utilizing KIO.PreviewJob.
	///  Currently, those classes don't support Drag&Drop out of the box -- there
	///  you have to use your own view-classes. You can use some DnD-aware views
	///  from Bj�n Sahlstr� <bjorn@kbear.org> until they will be integrated
	///  into this library. See http://devel-home.kde.org/~pfeiffer/DnD-classes.tar.gz
	///  This widget is the one used in the KFileDialog.
	///  Basic usage is like this:
	///  <pre>
	///    KDirOperator op = new KDirOperator( KUrl( "file:/home/gis" ), this );
	///    // some signals you might be interested in
	///    connect(op, SIGNAL("urlEntered(KUrl)"),
	///            SLOT("urlEntered(KUrl)"));
	///    connect(op, SIGNAL("fileHighlighted(KFileItem)"),
	///            SLOT("fileHighlighted(KFileItem)"));
	///    connect(op, SIGNAL("fileSelected(KFileItem)"),
	///            SLOT("fileSelected(KFileItem)"));
	///    connect(op, SIGNAL("finishedLoading()"),
	///            SLOT("slotLoadingFinished()"));
	///    KConfigGroup grp(KGlobal.Config(),"Your KDiroperator ConfigGroup" );
	///    op.ReadConfig( &grp);
	///    op.SetView(KFile.Default);
	///  </pre>
	///  This will create a childwidget of 'this' showing the directory contents
	///  of /home/gis in the default-view. The view is determined by the readConfig()
	///  call, which will read the KDirOperator settings, the user left your program
	///  with (and which you saved with op.WriteConfig()).
	///  See <see cref="IKDirOperatorSignals"></see> for signals emitted by KDirOperator
	/// </remarks>		<author> Stephan Kulow <coolo@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
	///  </author>
	/// 		<short> A widget for displaying files and browsing directories. </short>

	[SmokeClass("KDirOperator")]
	public class KDirOperator : QWidget, IDisposable {
 		protected KDirOperator(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KDirOperator), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KDirOperator() {
			staticInterceptor = new SmokeInvocation(typeof(KDirOperator), null);
		}
		/// <remarks>
		///  The various action types. These values can be or'd together
		///      </remarks>		<short>    The various action types.</short>
		public enum ActionType {
			SortActions = 1,
			ViewActions = 2,
			NavActions = 4,
			FileActions = 8,
			AllActions = 15,
		}
		// void setMode(KFile::Modes arg1); >>>> NOT CONVERTED
		// KFile::Modes mode(); >>>> NOT CONVERTED
		/// <remarks>
		///  Constructs the KDirOperator with no initial view. As the views are
		///  configurable, call readConfig() to load the user's configuration
		///  and then setView to explicitly set a view.
		///  This constructor doesn't start loading the url, setView will do it.
		///      </remarks>		<short>    Constructs the KDirOperator with no initial view.</short>
		public KDirOperator(KUrl urlName, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDirOperator##", "KDirOperator(const KUrl&, QWidget*)", typeof(void), typeof(KUrl), urlName, typeof(QWidget), parent);
		}
		public KDirOperator(KUrl urlName) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDirOperator#", "KDirOperator(const KUrl&)", typeof(void), typeof(KUrl), urlName);
		}
		public KDirOperator() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KDirOperator", "KDirOperator()", typeof(void));
		}
		/// <remarks>
		///  Enables/disables showing hidden files.
		///      </remarks>		<short>    Enables/disables showing hidden files.</short>
		[SmokeMethod("setShowHiddenFiles(bool)")]
		public virtual void SetShowHiddenFiles(bool s) {
			interceptor.Invoke("setShowHiddenFiles$", "setShowHiddenFiles(bool)", typeof(void), typeof(bool), s);
		}
		/// <remarks>
		/// </remarks>		<return> true when hidden files are shown or false otherwise.
		///      </return>
		/// 		<short>   </short>
		public bool ShowHiddenFiles() {
			return (bool) interceptor.Invoke("showHiddenFiles", "showHiddenFiles() const", typeof(bool));
		}
		/// <remarks>
		///  Stops loading immediately. You don't need to call this, usually.
		///      </remarks>		<short>    Stops loading immediately.</short>
		public new void Close() {
			interceptor.Invoke("close", "close()", typeof(void));
		}
		/// <remarks>
		///  Sets a filter like "*.cpp .h .o". Only files matching that filter
		///  will be shown.
		/// </remarks>		<short>    Sets a filter like " .</short>
		/// 		<see> KDirLister.SetNameFilter</see>
		/// 		<see> nameFilter</see>
		public void SetNameFilter(string filter) {
			interceptor.Invoke("setNameFilter$", "setNameFilter(const QString&)", typeof(void), typeof(string), filter);
		}
		/// <remarks>
		/// </remarks>		<return> the current namefilter.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setNameFilter</see>
		public string NameFilter() {
			return (string) interceptor.Invoke("nameFilter", "nameFilter() const", typeof(string));
		}
		/// <remarks>
		///  Sets a list of mimetypes as filter. Only files of those mimetypes
		///  will be shown.
		///  Example:
		///  <pre>
		///  List<string> filter;
		///  filter << "text/html" << "image/png" << "inode/directory";
		///  dirOperator.SetMimefilter( filter );
		///  </pre>
		///  Node: Without the mimetype inode/directory, only files would be shown.
		///  Call updateDir() to apply it.
		/// </remarks>		<short>    Sets a list of mimetypes as filter.</short>
		/// 		<see> KDirLister.SetMimeFilter</see>
		/// 		<see> mimeFilter</see>
		public void SetMimeFilter(List<string> mimetypes) {
			interceptor.Invoke("setMimeFilter?", "setMimeFilter(const QStringList&)", typeof(void), typeof(List<string>), mimetypes);
		}
		/// <remarks>
		/// </remarks>		<return> the current mime filter.
		///      </return>
		/// 		<short>   </short>
		public List<string> MimeFilter() {
			return (List<string>) interceptor.Invoke("mimeFilter", "mimeFilter() const", typeof(List<string>));
		}
		/// <remarks>
		///  Clears both the namefilter and mimetype filter, so that all files and
		///  directories will be shown. Call updateDir() to apply it.
		/// </remarks>		<short>    Clears both the namefilter and mimetype filter, so that all files and  directories will be shown.</short>
		/// 		<see> setMimeFilter</see>
		/// 		<see> setNameFilter</see>
		public void ClearFilter() {
			interceptor.Invoke("clearFilter", "clearFilter()", typeof(void));
		}
		/// <remarks>
		/// </remarks>		<return> the current url
		///      </return>
		/// 		<short>   </short>
		public KUrl Url() {
			return (KUrl) interceptor.Invoke("url", "url() const", typeof(KUrl));
		}
		/// <remarks>
		///  Sets a new url to list.
		/// <param> name="clearforward" specifies whether the "forward" history should be cleared.
		/// </param><param> name="url" the URL to set
		///      </param></remarks>		<short>    Sets a new url to list.</short>
		[SmokeMethod("setUrl(const KUrl&, bool)")]
		public virtual void SetUrl(KUrl url, bool clearforward) {
			interceptor.Invoke("setUrl#$", "setUrl(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), clearforward);
		}
		/// <remarks>
		///  Clears the current selection and attempts to set <code>filename</code>
		///  the current file. filename is just the name, no path or url.
		///      </remarks>		<short>    Clears the current selection and attempts to set <code>filename</code>  the current file.</short>
		public void SetCurrentItem(string filename) {
			interceptor.Invoke("setCurrentItem$", "setCurrentItem(const QString&)", typeof(void), typeof(string), filename);
		}
		/// <remarks>
		///  Sets a new KFileView to be used for showing and browsing files.
		///  Note: this will read the current url() to fill the view.
		/// </remarks>		<short>    Sets a new KFileView to be used for showing and browsing files.</short>
		/// 		<see> KFileView</see>
		/// 		<see> KFileIconView</see>
		/// 		<see> KFileDetailView</see>
		/// 		<see> KCombiView</see>
		/// 		<see> view</see>
		[SmokeMethod("setView(QAbstractItemView*)")]
		public virtual void SetView(QAbstractItemView view) {
			interceptor.Invoke("setView#", "setView(QAbstractItemView*)", typeof(void), typeof(QAbstractItemView), view);
		}
		/// <remarks>
		/// </remarks>		<return> the currently used view.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setView</see>
		public QAbstractItemView View() {
			return (QAbstractItemView) interceptor.Invoke("view", "view() const", typeof(QAbstractItemView));
		}
		/// <remarks>
		///  Sets one of the predefined fileviews.
		/// </remarks>		<short>    Sets one of the predefined fileviews.</short>
		/// 		<see> KFile.FileView</see>
		[SmokeMethod("setView(KFile::FileView)")]
		public virtual void SetView(int viewKind) {
			interceptor.Invoke("setView?", "setView(KFile::FileView)", typeof(void), typeof(int), viewKind);
		}
		/// <remarks>
		///  Sets the way to sort files and directories.
		///      </remarks>		<short>    Sets the way to sort files and directories.</short>
		public void SetSorting(uint arg1) {
			interceptor.Invoke("setSorting$", "setSorting(QDir::SortFlags)", typeof(void), typeof(uint), arg1);
		}
		/// <remarks>
		/// </remarks>		<return> the current way of sorting files and directories
		///      </return>
		/// 		<short>   </short>
		public uint Sorting() {
			return (uint) interceptor.Invoke("sorting", "sorting() const", typeof(uint));
		}
		/// <remarks>
		/// </remarks>		<return> true if we are displaying the root directory of the current url
		///      </return>
		/// 		<short>   </short>
		public bool IsRoot() {
			return (bool) interceptor.Invoke("isRoot", "isRoot() const", typeof(bool));
		}
		/// <remarks>
		/// </remarks>		<return> the object listing the directory
		///      </return>
		/// 		<short>   </short>
		public KDirLister DirLister() {
			return (KDirLister) interceptor.Invoke("dirLister", "dirLister() const", typeof(KDirLister));
		}
		/// <remarks>
		/// </remarks>		<return> the progress widget, that is shown during directory listing.
		///  You can for example reparent() it to put it into a statusbar.
		///      </return>
		/// 		<short>   </short>
		public QProgressBar ProgressBar() {
			return (QProgressBar) interceptor.Invoke("progressBar", "progressBar() const", typeof(QProgressBar));
		}
		/// <remarks>
		///  Sets the listing/selection mode for the views, an OR'ed combination of
		/// 
		/// <li>
		/// File
		/// </li>
		/// 
		/// <li>
		/// Directory
		/// </li>
		/// 
		/// <li>
		/// Files
		/// </li>
		/// 
		/// <li>
		/// ExistingOnly
		/// </li>
		/// 
		/// <li>
		/// LocalOnly
		/// </li>
		///  You cannot mix File and Files of course, as the former means
		///  single-selection mode, the latter multi-selection.
		///      </remarks>		<short>    Sets the listing/selection mode for the views, an OR'ed combination of </short>
		/// <remarks>
		/// </remarks>		<return> the listing/selection mode.
		///      </return>
		/// 		<short>   </short>
		/// <remarks>
		///  Sets a preview-widget to be shown next to the file-view.
		///  The ownership of <code>w</code> is transferred to KDirOperator, so don't
		///  delete it yourself!
		///      </remarks>		<short>    Sets a preview-widget to be shown next to the file-view.</short>
		[SmokeMethod("setPreviewWidget(KPreviewWidgetBase*)")]
		public virtual void SetPreviewWidget(KPreviewWidgetBase w) {
			interceptor.Invoke("setPreviewWidget#", "setPreviewWidget(KPreviewWidgetBase*)", typeof(void), typeof(KPreviewWidgetBase), w);
		}
		/// <remarks>
		/// </remarks>		<return> a list of all currently selected items. If there is no view,
		///  or there are no selected items, an empty list is returned.
		///      </return>
		/// 		<short>   </short>
		public List<KFileItem> SelectedItems() {
			return (List<KFileItem>) interceptor.Invoke("selectedItems", "selectedItems() const", typeof(List<KFileItem>));
		}
		/// <remarks>
		/// </remarks>		<return> true if <code>item</code> is currently selected, or false otherwise.
		///      </return>
		/// 		<short>   </short>
		public bool IsSelected(KFileItem item) {
			return (bool) interceptor.Invoke("isSelected#", "isSelected(const KFileItem&) const", typeof(bool), typeof(KFileItem), item);
		}
		/// <remarks>
		/// </remarks>		<return> the number of directories in the currently listed url.
		///  Returns 0 if there is no view.
		///      </return>
		/// 		<short>   </short>
		public int NumDirs() {
			return (int) interceptor.Invoke("numDirs", "numDirs() const", typeof(int));
		}
		/// <remarks>
		/// </remarks>		<return> the number of files in the currently listed url.
		///  Returns 0 if there is no view.
		///      </return>
		/// 		<short>   </short>
		public int NumFiles() {
			return (int) interceptor.Invoke("numFiles", "numFiles() const", typeof(int));
		}
		/// <remarks>
		/// </remarks>		<return> a KCompletion object, containing all filenames and
		///  directories of the current directory/URL.
		///  You can use it to insert it into a KLineEdit or KComboBox
		///  Note: it will only contain files, after prepareCompletionObjects()
		///  has been called. It will be implicitly called from makeCompletion()
		///  or makeDirCompletion()
		///      </return>
		/// 		<short>   </short>
		public KCompletion CompletionObject() {
			return (KCompletion) interceptor.Invoke("completionObject", "completionObject() const", typeof(KCompletion));
		}
		/// <remarks>
		/// </remarks>		<return> a KCompletion object, containing only all directories of the
		///  current directory/URL.
		///  You can use it to insert it into a KLineEdit or KComboBox
		///  Note: it will only contain directories, after
		///  prepareCompletionObjects() has been called. It will be implicitly
		///  called from makeCompletion() or makeDirCompletion()
		///      </return>
		/// 		<short>   </short>
		public KCompletion DirCompletionObject() {
			return (KCompletion) interceptor.Invoke("dirCompletionObject", "dirCompletionObject() const", typeof(KCompletion));
		}
		/// <remarks>
		///  an accessor to a collection of all available Actions. The actions
		///  are static, they will be there all the time (no need to connect to
		///  the signals KActionCollection.Inserted() or removed().
		///  There are the following actions:
		/// 
		/// <li>
		/// popupMenu : an ActionMenu presenting a popupmenu with all actions
		/// </li>
		/// 
		/// <li>
		/// up : changes to the parent directory
		/// </li>
		/// 
		/// <li>
		/// back : goes back to the previous directory
		/// </li>
		/// 
		/// <li>
		/// forward : goes forward in the history
		/// </li>
		/// 
		/// <li>
		/// home : changes to the user's home directory
		/// </li>
		/// 
		/// <li>
		/// reload : reloads the current directory
		/// </li>
		/// 
		/// <li>
		/// mkdir : opens a dialog box to create a directory
		/// </li>
		/// 
		/// <li>
		/// delete : deletes the selected files/directories
		/// </li>
		/// 
		/// <li>
		/// sorting menu : an ActionMenu containing all sort-options
		/// </li>
		/// 
		/// <li>
		/// by name : sorts by name
		/// </li>
		/// 
		/// <li>
		/// by size : sorts by size
		/// </li>
		/// 
		/// <li>
		/// by date : sorts by date
		/// </li>
		/// 
		/// <li>
		/// by type : sorts by type
		/// </li>
		/// 
		/// <li>
		/// descending : reverses the sort order
		/// </li>
		/// 
		/// <li>
		/// view menu : an ActionMenu containing all actions concerning the view
		/// </li>
		/// 
		/// <li>
		/// short view : shows a simple fileview
		/// </li>
		/// 
		/// <li>
		/// detailed view : shows a detailed fileview (dates, permissions ,...)
		/// </li>
		/// 
		/// <li>
		/// show hidden : shows hidden files
		/// </li>
		/// 
		/// <li>
		/// preview  : shows a preview next to the fileview
		/// </li>
		/// 
		/// <li>
		/// properties : shows a KPropertiesDialog for the selected files
		/// </li>
		///  The short and detailed view are in an exclusive group. The sort-by
		///  actions are in an exclusive group as well. Also the "separate dirs",
		///  "preview" and "single" actions are in an exclusive group.
		///  You can e.g. use
		///  <pre>
		///  actionCollection().Action( "up" ).Plug( someToolBar );
		///  </pre>
		///  to add a button into a toolbar, which makes the dirOperator change to
		///  its parent directory.
		/// </remarks>		<return> all available Actions
		///      </return>
		/// 		<short>    an accessor to a collection of all available Actions.</short>
		public KActionCollection ActionCollection() {
			return (KActionCollection) interceptor.Invoke("actionCollection", "actionCollection() const", typeof(KActionCollection));
		}
		/// <remarks>
		///  Sets the config object and the to be used group in KDirOperator. This
		///  will be used to store the view's configuration via
		///  KFileView.WriteConfig() (and for KFileView.ReadConfig()).
		///  If you don't set this, the views cannot save and restore their
		///  configuration.
		///  Usually you call this right after KDirOperator creation so that the view
		///  instantiation can make use of it already.
		///  Note that KDirOperator does NOT take ownership of that object (typically
		///  it's KGlobal.Config() anyway.
		///  You must not delete the KConfig or KConfigGroup object (and master config object) before
		///  either deleting the KDirOperator or  calling setViewConfig(0); or something like that
		/// </remarks>		<short>    Sets the config object and the to be used group in KDirOperator.</short>
		/// 		<see> viewConfig</see>
		/// 		<see> viewConfigGroup</see>
		[SmokeMethod("setViewConfig(KConfigGroup&)")]
		public virtual void SetViewConfig(KConfigGroup configGroup) {
			interceptor.Invoke("setViewConfig#", "setViewConfig(KConfigGroup&)", typeof(void), typeof(KConfigGroup), configGroup);
		}
		public KConfigGroup ViewConfigGroup() {
			return (KConfigGroup) interceptor.Invoke("viewConfigGroup", "viewConfigGroup() const", typeof(KConfigGroup));
		}
		/// <remarks>
		///  Reads the default settings for a view, i.e. the default KFile.FileView.
		///  Also reads the sorting and whether hidden files should be shown.
		///  Note: the default view will not be set - you have to call
		///  <pre>
		///  setView( KFile.Default )
		///  </pre>
		///  to apply it.
		/// </remarks>		<short>    Reads the default settings for a view, i.</short>
		/// 		<see> setView</see>
		/// 		<see> setViewConfig</see>
		/// 		<see> writeConfig</see>
		[SmokeMethod("readConfig(const KConfigGroup&)")]
		public virtual void ReadConfig(KConfigGroup configGroup) {
			interceptor.Invoke("readConfig#", "readConfig(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), configGroup);
		}
		/// <remarks>
		///  Saves the current settings like sorting, simple or detailed view.
		/// </remarks>		<short>    Saves the current settings like sorting, simple or detailed view.</short>
		/// 		<see> readConfig</see>
		/// 		<see> setViewConfig</see>
		[SmokeMethod("writeConfig(KConfigGroup&)")]
		public virtual void WriteConfig(KConfigGroup configGroup) {
			interceptor.Invoke("writeConfig#", "writeConfig(KConfigGroup&)", typeof(void), typeof(KConfigGroup), configGroup);
		}
		/// <remarks>
		///  This is a KFileDialog specific hack: we want to select directories with
		///  single click, but not files. But as a generic class, we have to be able
		///  to select files on single click as well.
		///  This gives us the opportunity to do both.
		///  The default is false, set it to true if you don't want files selected
		///  with single click.
		///      </remarks>		<short>    This is a KFileDialog specific hack: we want to select directories with  single click, but not files.</short>
		public void SetOnlyDoubleClickSelectsFiles(bool enable) {
			interceptor.Invoke("setOnlyDoubleClickSelectsFiles$", "setOnlyDoubleClickSelectsFiles(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		/// </remarks>		<return> whether files (not directories) should only be select()ed by
		///  double-clicks.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> setOnlyDoubleClickSelectsFiles</see>
		public bool OnlyDoubleClickSelectsFiles() {
			return (bool) interceptor.Invoke("onlyDoubleClickSelectsFiles", "onlyDoubleClickSelectsFiles() const", typeof(bool));
		}
		/// <remarks>
		///  Creates the given directory/url. If it is a relative path,
		///  it will be completed with the current directory.
		///  If enterDirectory is true, the directory will be entered after a
		///  successful operation. If unsuccessful, a messagebox will be presented
		///  to the user.
		/// </remarks>		<return> true if the directory could be created.
		///      </return>
		/// 		<short>    Creates the given directory/url.</short>
		[SmokeMethod("mkdir(const QString&, bool)")]
		public virtual bool Mkdir(string directory, bool enterDirectory) {
			return (bool) interceptor.Invoke("mkdir$$", "mkdir(const QString&, bool)", typeof(bool), typeof(string), directory, typeof(bool), enterDirectory);
		}
		[SmokeMethod("mkdir(const QString&)")]
		public virtual bool Mkdir(string directory) {
			return (bool) interceptor.Invoke("mkdir$", "mkdir(const QString&)", typeof(bool), typeof(string), directory);
		}
		/// <remarks>
		///  Starts and returns a KIO.DeleteJob to delete the given <code>items.</code>
		/// <param> name="items" the list of items to be deleted
		/// </param><param> name="parent" the parent widget used for the confirmation dialog
		/// </param><param> name="ask" specifies whether a confirmation dialog should be shown
		/// </param><param> name="showProgress" passed to the DeleteJob to show a progress dialog
		///      </param></remarks>		<short>    Starts and returns a KIO.DeleteJob to delete the given <code>items.</code></short>
		[SmokeMethod("del(const KFileItemList&, QWidget*, bool, bool)")]
		public virtual KIO.DeleteJob Del(List<KFileItem> items, QWidget parent, bool ask, bool showProgress) {
			return (KIO.DeleteJob) interceptor.Invoke("del##$$", "del(const KFileItemList&, QWidget*, bool, bool)", typeof(KIO.DeleteJob), typeof(List<KFileItem>), items, typeof(QWidget), parent, typeof(bool), ask, typeof(bool), showProgress);
		}
		[SmokeMethod("del(const KFileItemList&, QWidget*, bool)")]
		public virtual KIO.DeleteJob Del(List<KFileItem> items, QWidget parent, bool ask) {
			return (KIO.DeleteJob) interceptor.Invoke("del##$", "del(const KFileItemList&, QWidget*, bool)", typeof(KIO.DeleteJob), typeof(List<KFileItem>), items, typeof(QWidget), parent, typeof(bool), ask);
		}
		[SmokeMethod("del(const KFileItemList&, QWidget*)")]
		public virtual KIO.DeleteJob Del(List<KFileItem> items, QWidget parent) {
			return (KIO.DeleteJob) interceptor.Invoke("del##", "del(const KFileItemList&, QWidget*)", typeof(KIO.DeleteJob), typeof(List<KFileItem>), items, typeof(QWidget), parent);
		}
		[SmokeMethod("del(const KFileItemList&)")]
		public virtual KIO.DeleteJob Del(List<KFileItem> items) {
			return (KIO.DeleteJob) interceptor.Invoke("del#", "del(const KFileItemList&)", typeof(KIO.DeleteJob), typeof(List<KFileItem>), items);
		}
		/// <remarks>
		///  Clears the forward and backward history.
		///      </remarks>		<short>    Clears the forward and backward history.</short>
		public void ClearHistory() {
			interceptor.Invoke("clearHistory", "clearHistory()", typeof(void));
		}
		/// <remarks>
		///  When going up in the directory hierarchy, KDirOperator can highlight
		///  the directory that was just left.
		///  I.e. when you go from /home/gis/src to /home/gis, the item "src" will
		///  be made the current item.
		///  Default is off.
		///      </remarks>		<short>    When going up in the directory hierarchy, KDirOperator can highlight  the directory that was just left.</short>
		[SmokeMethod("setEnableDirHighlighting(bool)")]
		public virtual void SetEnableDirHighlighting(bool enable) {
			interceptor.Invoke("setEnableDirHighlighting$", "setEnableDirHighlighting(bool)", typeof(void), typeof(bool), enable);
		}
		/// <remarks>
		///  Default is false.
		///      </remarks>		<return> whether the last directory will be made the current item
		///  when going up in the directory hierarchy.
		/// </return>
		/// 		<short>   </short>
		public bool DirHighlighting() {
			return (bool) interceptor.Invoke("dirHighlighting", "dirHighlighting() const", typeof(bool));
		}
		/// <remarks>
		/// </remarks>		<return> true if we are in directory-only mode, that is, no files are
		///  shown.
		///      </return>
		/// 		<short>   </short>
		public bool DirOnlyMode() {
			return (bool) interceptor.Invoke("dirOnlyMode", "dirOnlyMode() const", typeof(bool));
		}
		/// <remarks>
		///  Sets up the action menu.
		/// <param> name="whichActions" is an value of OR'd ActionTypes that controls which actions to show in the action menu
		///      </param></remarks>		<short>    Sets up the action menu.</short>
		public void SetupMenu(int whichActions) {
			interceptor.Invoke("setupMenu$", "setupMenu(int)", typeof(void), typeof(int), whichActions);
		}
		/// <remarks>
		///  Reimplemented - allow dropping of files if <code>b</code> is true
		/// <param> name="b" true if the widget should allow dropping of files
		///      </param></remarks>		<short>    Reimplemented - allow dropping of files if <code>b</code> is true </short>
		[SmokeMethod("setAcceptDrops(bool)")]
		public virtual void SetAcceptDrops(bool b) {
			interceptor.Invoke("setAcceptDrops$", "setAcceptDrops(bool)", typeof(void), typeof(bool), b);
		}
		/// <remarks>
		///  Sets the options for dropping files.
		/// </remarks>		<short>    Sets the options for dropping files.</short>
		/// 		<see> KFileView.DropOptions</see>
		[SmokeMethod("setDropOptions(int)")]
		public virtual void SetDropOptions(int options) {
			interceptor.Invoke("setDropOptions$", "setDropOptions(int)", typeof(void), typeof(int), options);
		}
		/// <remarks>
		///  Starts and returns a KIO.CopyJob to trash the given <code>items.</code>
		/// <param> name="items" the list of items to be trashed
		/// </param><param> name="parent" the parent widget used for the confirmation dialog
		/// </param><param> name="ask" specifies whether a confirmation dialog should be shown
		/// </param><param> name="showProgress" passed to the CopyJob to show a progress dialog
		///      </param></remarks>		<short>    Starts and returns a KIO.CopyJob to trash the given <code>items.</code></short>
		[SmokeMethod("trash(const KFileItemList&, QWidget*, bool, bool)")]
		public virtual KIO.CopyJob Trash(List<KFileItem> items, QWidget parent, bool ask, bool showProgress) {
			return (KIO.CopyJob) interceptor.Invoke("trash##$$", "trash(const KFileItemList&, QWidget*, bool, bool)", typeof(KIO.CopyJob), typeof(List<KFileItem>), items, typeof(QWidget), parent, typeof(bool), ask, typeof(bool), showProgress);
		}
		[SmokeMethod("trash(const KFileItemList&, QWidget*, bool)")]
		public virtual KIO.CopyJob Trash(List<KFileItem> items, QWidget parent, bool ask) {
			return (KIO.CopyJob) interceptor.Invoke("trash##$", "trash(const KFileItemList&, QWidget*, bool)", typeof(KIO.CopyJob), typeof(List<KFileItem>), items, typeof(QWidget), parent, typeof(bool), ask);
		}
		[SmokeMethod("trash(const KFileItemList&, QWidget*)")]
		public virtual KIO.CopyJob Trash(List<KFileItem> items, QWidget parent) {
			return (KIO.CopyJob) interceptor.Invoke("trash##", "trash(const KFileItemList&, QWidget*)", typeof(KIO.CopyJob), typeof(List<KFileItem>), items, typeof(QWidget), parent);
		}
		/// <remarks>
		///  Goes one step back in the history and opens that url.
		///      </remarks>		<short>    Goes one step back in the history and opens that url.</short>
		[Q_SLOT("void back()")]
		[SmokeMethod("back()")]
		public virtual void Back() {
			interceptor.Invoke("back", "back()", typeof(void));
		}
		/// <remarks>
		///  Goes one step forward in the history and opens that url.
		///      </remarks>		<short>    Goes one step forward in the history and opens that url.</short>
		[Q_SLOT("void forward()")]
		[SmokeMethod("forward()")]
		public virtual void Forward() {
			interceptor.Invoke("forward", "forward()", typeof(void));
		}
		/// <remarks>
		///  Enters the home directory.
		///      </remarks>		<short>    Enters the home directory.</short>
		[Q_SLOT("void home()")]
		[SmokeMethod("home()")]
		public virtual void Home() {
			interceptor.Invoke("home", "home()", typeof(void));
		}
		/// <remarks>
		///  Goes one directory up from the current url.
		///      </remarks>		<short>    Goes one directory up from the current url.</short>
		[Q_SLOT("void cdUp()")]
		[SmokeMethod("cdUp()")]
		public virtual void CdUp() {
			interceptor.Invoke("cdUp", "cdUp()", typeof(void));
		}
		/// <remarks>
		///  to update the view after changing the settings
		///      </remarks>		<short>    to update the view after changing the settings      </short>
		[Q_SLOT("void updateDir()")]
		public void UpdateDir() {
			interceptor.Invoke("updateDir", "updateDir()", typeof(void));
		}
		/// <remarks>
		///  Re-reads the current url.
		///      </remarks>		<short>    Re-reads the current url.</short>
		[Q_SLOT("void rereadDir()")]
		[SmokeMethod("rereadDir()")]
		public virtual void RereadDir() {
			interceptor.Invoke("rereadDir", "rereadDir()", typeof(void));
		}
		/// <remarks>
		///  Opens a dialog to create a new directory.
		///      </remarks>		<short>    Opens a dialog to create a new directory.</short>
		[Q_SLOT("void mkdir()")]
		[SmokeMethod("mkdir()")]
		public virtual void Mkdir() {
			interceptor.Invoke("mkdir", "mkdir()", typeof(void));
		}
		/// <remarks>
		///  Deletes the currently selected files/directories.
		///      </remarks>		<short>    Deletes the currently selected files/directories.</short>
		[Q_SLOT("void deleteSelected()")]
		[SmokeMethod("deleteSelected()")]
		public virtual void DeleteSelected() {
			interceptor.Invoke("deleteSelected", "deleteSelected()", typeof(void));
		}
		/// <remarks>
		///  Enables/disables actions that are selection dependent. Call this e.g.
		///  when you are about to show a popup menu using some of KDirOperators
		///  actions.
		///      </remarks>		<short>    Enables/disables actions that are selection dependent.</short>
		[Q_SLOT("void updateSelectionDependentActions()")]
		public void UpdateSelectionDependentActions() {
			interceptor.Invoke("updateSelectionDependentActions", "updateSelectionDependentActions()", typeof(void));
		}
		/// <remarks>
		///  Tries to complete the given string (only completes files).
		///      </remarks>		<short>    Tries to complete the given string (only completes files).</short>
		[Q_SLOT("QString makeCompletion(const QString&)")]
		public string MakeCompletion(string arg1) {
			return (string) interceptor.Invoke("makeCompletion$", "makeCompletion(const QString&)", typeof(string), typeof(string), arg1);
		}
		/// <remarks>
		///  Tries to complete the given string (only completes directores).
		///      </remarks>		<short>    Tries to complete the given string (only completes directores).</short>
		[Q_SLOT("QString makeDirCompletion(const QString&)")]
		public string MakeDirCompletion(string arg1) {
			return (string) interceptor.Invoke("makeDirCompletion$", "makeDirCompletion(const QString&)", typeof(string), typeof(string), arg1);
		}
		/// <remarks>
		///  Trashes the currently selected files/directories.
		///  This function used to take activation reason and keyboard modifiers,
		///  in order to call deleteSelected() if the user wanted to delete.
		///  Instead, call deleteSelected().
		///  FIXME KAction Port: link deleteSelected() up correctly
		///      </remarks>		<short>    Trashes the currently selected files/directories.</short>
		[Q_SLOT("void trashSelected()")]
		[SmokeMethod("trashSelected()")]
		public virtual void TrashSelected() {
			interceptor.Invoke("trashSelected", "trashSelected()", typeof(void));
		}
		/// <remarks>
		///  A view factory for creating predefined fileviews. Called internally by setView,
		///  but you can also call it directly. Reimplement this if you depend on self defined fileviews.
		/// <param> name="parent" is the QWidget to be set as parent
		/// </param><param> name="viewKind" is the predefined view to be set, note: this can be several ones OR:ed together
		/// </param></remarks>		<return> the created KFileView
		/// </return>
		/// 		<short>    A view factory for creating predefined fileviews.</short>
		/// 		<see> KFile.FileView</see>
		/// 		<see> setView</see>
		[SmokeMethod("createView(QWidget*, KFile::FileView)")]
		protected virtual QAbstractItemView CreateView(QWidget parent, int viewKind) {
			return (QAbstractItemView) interceptor.Invoke("createView#?", "createView(QWidget*, KFile::FileView)", typeof(QAbstractItemView), typeof(QWidget), parent, typeof(int), viewKind);
		}
		/// <remarks>
		///  Sets a custom KDirLister to list directories.
		///      </remarks>		<short>    Sets a custom KDirLister to list directories.</short>
		[SmokeMethod("setDirLister(KDirLister*)")]
		protected virtual void SetDirLister(KDirLister lister) {
			interceptor.Invoke("setDirLister#", "setDirLister(KDirLister*)", typeof(void), typeof(KDirLister), lister);
		}
		[SmokeMethod("resizeEvent(QResizeEvent*)")]
		protected override void ResizeEvent(QResizeEvent arg1) {
			interceptor.Invoke("resizeEvent#", "resizeEvent(QResizeEvent*)", typeof(void), typeof(QResizeEvent), arg1);
		}
		/// <remarks>
		///  Sets up all the actions. Called from the constructor, you usually
		///  better not call this.
		///      </remarks>		<short>    Sets up all the actions.</short>
		protected void SetupActions() {
			interceptor.Invoke("setupActions", "setupActions()", typeof(void));
		}
		/// <remarks>
		///  Updates the sorting-related actions to comply with the current sorting
		/// </remarks>		<short>    Updates the sorting-related actions to comply with the current sorting </short>
		/// 		<see> sorting</see>
		protected void UpdateSortActions() {
			interceptor.Invoke("updateSortActions", "updateSortActions()", typeof(void));
		}
		/// <remarks>
		///  Updates the view-related actions to comply with the current
		///  KFile.FileView
		///      </remarks>		<short>    Updates the view-related actions to comply with the current  KFile.FileView      </short>
		protected void UpdateViewActions() {
			interceptor.Invoke("updateViewActions", "updateViewActions()", typeof(void));
		}
		/// <remarks>
		///  Sets up the context-menu with all the necessary actions. Called from the
		///  constructor, you usually don't need to call this.
		///      </remarks>		<short>    Sets up the context-menu with all the necessary actions.</short>
		protected void SetupMenu() {
			interceptor.Invoke("setupMenu", "setupMenu()", typeof(void));
		}
		/// <remarks>
		///  Synchronizes the completion objects with the entries of the
		///  currently listed url.
		///  Automatically called from makeCompletion() and
		///  makeDirCompletion()
		///      </remarks>		<short>    Synchronizes the completion objects with the entries of the  currently listed url.</short>
		protected void PrepareCompletionObjects() {
			interceptor.Invoke("prepareCompletionObjects", "prepareCompletionObjects()", typeof(void));
		}
		/// <remarks>
		///  Checks if there support from KIO.PreviewJob for the currently
		///  shown files, taking mimeFilter() and nameFilter() into account
		///  Enables/disables the preview-action accordingly.
		///      </remarks>		<short>    Checks if there support from KIO.PreviewJob for the currently  shown files, taking mimeFilter() and nameFilter() into account  Enables/disables the preview-action accordingly.</short>
		protected bool CheckPreviewSupport() {
			return (bool) interceptor.Invoke("checkPreviewSupport", "checkPreviewSupport()", typeof(bool));
		}
		/// <remarks>
		///  Called upon right-click to activate the popupmenu.
		///      </remarks>		<short>    Called upon right-click to activate the popupmenu.</short>
		[SmokeMethod("activatedMenu(const KFileItem&, const QPoint&)")]
		protected virtual void ActivatedMenu(KFileItem item, QPoint pos) {
			interceptor.Invoke("activatedMenu##", "activatedMenu(const KFileItem&, const QPoint&)", typeof(void), typeof(KFileItem), item, typeof(QPoint), pos);
		}
		/// <remarks>
		///  Restores the normal cursor after showing the busy-cursor. Also hides
		///  the progressbar.
		///      </remarks>		<short>    Restores the normal cursor after showing the busy-cursor.</short>
		[Q_SLOT("void resetCursor()")]
		protected void ResetCursor() {
			interceptor.Invoke("resetCursor", "resetCursor()", typeof(void));
		}
		/// <remarks>
		///  Called after setUrl() to load the directory, update the history,
		///  etc.
		///      </remarks>		<short>    Called after setUrl() to load the directory, update the history,  etc.</short>
		[Q_SLOT("void pathChanged()")]
		protected void PathChanged() {
			interceptor.Invoke("pathChanged", "pathChanged()", typeof(void));
		}
		/// <remarks>
		///  Enters the directory specified by the given <code>item.</code>
		///      </remarks>		<short>    Enters the directory specified by the given <code>item.</code></short>
		[Q_SLOT("void selectDir(const KFileItem&)")]
		[SmokeMethod("selectDir(const KFileItem&)")]
		protected virtual void SelectDir(KFileItem item) {
			interceptor.Invoke("selectDir#", "selectDir(const KFileItem&)", typeof(void), typeof(KFileItem), item);
		}
		/// <remarks>
		///  Emits fileSelected( item )
		///      </remarks>		<short>    Emits fileSelected( item )      </short>
		[Q_SLOT("void selectFile(const KFileItem&)")]
		protected void SelectFile(KFileItem item) {
			interceptor.Invoke("selectFile#", "selectFile(const KFileItem&)", typeof(void), typeof(KFileItem), item);
		}
		/// <remarks>
		///  Emits fileHighlighted(item)
		///      </remarks>		<short>    Emits fileHighlighted(item)      </short>
		[Q_SLOT("void highlightFile(const KFileItem&)")]
		protected void HighlightFile(KFileItem item) {
			interceptor.Invoke("highlightFile#", "highlightFile(const KFileItem&)", typeof(void), typeof(KFileItem), item);
		}
		/// <remarks>
		///  Changes sorting to sort by name
		///      </remarks>		<short>    Changes sorting to sort by name      </short>
		[Q_SLOT("void sortByName()")]
		protected void SortByName() {
			interceptor.Invoke("sortByName", "sortByName()", typeof(void));
		}
		/// <remarks>
		///  Changes sorting to sort by size
		///      </remarks>		<short>    Changes sorting to sort by size      </short>
		[Q_SLOT("void sortBySize()")]
		protected void SortBySize() {
			interceptor.Invoke("sortBySize", "sortBySize()", typeof(void));
		}
		/// <remarks>
		///  Changes sorting to sort by date
		///      </remarks>		<short>    Changes sorting to sort by date      </short>
		[Q_SLOT("void sortByDate()")]
		protected void SortByDate() {
			interceptor.Invoke("sortByDate", "sortByDate()", typeof(void));
		}
		/// <remarks>
		///  Changes sorting to sort by date
		///      </remarks>		<short>    Changes sorting to sort by date      </short>
		[Q_SLOT("void sortByType()")]
		protected void SortByType() {
			interceptor.Invoke("sortByType", "sortByType()", typeof(void));
		}
		/// <remarks>
		///  Changes sorting to reverse sorting
		///      </remarks>		<short>    Changes sorting to reverse sorting      </short>
		[Q_SLOT("void sortReversed()")]
		protected void SortReversed() {
			interceptor.Invoke("sortReversed", "sortReversed()", typeof(void));
		}
		/// <remarks>
		///  Toggles showing directories first / having them sorted like files.
		///      </remarks>		<short>    Toggles showing directories first / having them sorted like files.</short>
		[Q_SLOT("void toggleDirsFirst()")]
		protected void ToggleDirsFirst() {
			interceptor.Invoke("toggleDirsFirst", "toggleDirsFirst()", typeof(void));
		}
		/// <remarks>
		///  Toggles case sensitive / case insensitive sorting
		///      </remarks>		<short>    Toggles case sensitive / case insensitive sorting      </short>
		[Q_SLOT("void toggleIgnoreCase()")]
		protected void ToggleIgnoreCase() {
			interceptor.Invoke("toggleIgnoreCase", "toggleIgnoreCase()", typeof(void));
		}
		/// <remarks>
		///  Tries to make the given <code>match</code> as current item in the view and emits
		///  completion( match )
		///      </remarks>		<short>    Tries to make the given <code>match</code> as current item in the view and emits  completion( match )      </short>
		[Q_SLOT("void slotCompletionMatch(const QString&)")]
		protected void SlotCompletionMatch(string match) {
			interceptor.Invoke("slotCompletionMatch$", "slotCompletionMatch(const QString&)", typeof(void), typeof(string), match);
		}
		~KDirOperator() {
			interceptor.Invoke("~KDirOperator", "~KDirOperator()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KDirOperator", "~KDirOperator()", typeof(void));
		}
		public static bool DirOnlyMode(uint mode) {
			return (bool) staticInterceptor.Invoke("dirOnlyMode$", "dirOnlyMode(uint)", typeof(bool), typeof(uint), mode);
		}
		protected new IKDirOperatorSignals Emit {
			get { return (IKDirOperatorSignals) Q_EMIT; }
		}
	}

	public interface IKDirOperatorSignals : IQWidgetSignals {
		[Q_SIGNAL("void urlEntered(const KUrl&)")]
		void UrlEntered(KUrl arg1);
		[Q_SIGNAL("void updateInformation(int, int)")]
		void UpdateInformation(int files, int dirs);
		[Q_SIGNAL("void completion(const QString&)")]
		void Completion(string arg1);
		[Q_SIGNAL("void finishedLoading()")]
		void FinishedLoading();
		/// <remarks>
		///  Emitted whenever the current fileview is changed, either by an explicit
		///  call to setView() or by the user selecting a different view thru
		///  the GUI.
		///      </remarks>		<short>    Emitted whenever the current fileview is changed, either by an explicit  call to setView() or by the user selecting a different view thru  the GUI.</short>
		[Q_SIGNAL("void viewChanged(QAbstractItemView*)")]
		void ViewChanged(QAbstractItemView newView);
		/// <remarks>
		///  Emitted when a file is highlighted or generally the selection changes in
		///  multiselection mode. In the latter case, <code>item</code> is null. You can access
		///  the selected items with selectedItems().
		///      </remarks>		<short>    Emitted when a file is highlighted or generally the selection changes in  multiselection mode.</short>
		[Q_SIGNAL("void fileHighlighted(const KFileItem&)")]
		void FileHighlighted(KFileItem item);
		[Q_SIGNAL("void dirActivated(const KFileItem&)")]
		void DirActivated(KFileItem item);
		[Q_SIGNAL("void fileSelected(const KFileItem&)")]
		void FileSelected(KFileItem item);
		/// <remarks>
		///  Emitted when files are dropped. Dropping files is disabled by
		///  default. You need to enable it with setAcceptDrops()
		/// <param> name="item" the item on which the drop occurred or 0.
		/// </param><param> name="event" the drop event itself.
		/// </param><param> name="urls" the urls that where dropped.
		///      </param></remarks>		<short>    Emitted when files are dropped.</short>
		[Q_SIGNAL("void dropped(const KFileItem&, QDropEvent*, const KUrl::List&)")]
		void Dropped(KFileItem item, QDropEvent arg2, List<KUrl> urls);
	}
}
