/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "pwmviewstyle.h"
#include "pwmexception.h"
#include "pwmviewstyle_0.h"
#include "pwmviewstyle_1.h"
#include "listviewpwm.h"
#include "pwmview.h"
#include "commentbox.h"


PwMViewStyle::PwMViewStyle(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	curStyle = style_notset;
	s0 = 0;
	s1 = 0;
}

PwMViewStyle::~PwMViewStyle()
{
	delete_ifnot_null(s0);
	delete_ifnot_null(s1);
}

void PwMViewStyle::initStyle(style_t style)
{
	printDebug(string("initializing style ") + tostr(style));
	bool wasMaximized = v->isMaximized();
	if (v->isVisible())
		v->hide();
	switch (style) {
	case style_0:
		delete_ifnot_null(s0);
		delete_ifnot_null(s1);
		s0 = new PwMViewStyle_0(v);
		lv = s0->getLv();
		commentBox = s0->getCommentBox();
		break;
	case style_1:
		delete_ifnot_null(s0);
		delete_ifnot_null(s1);
		s1 = new PwMViewStyle_1(v);
		lv = s1->getLv();
		commentBox = s1->getCommentBox();
		break;
	default:
		BUG();
		return;
	}
	curStyle = style;
	connect(lv, SIGNAL(pressed(QListViewItem *)),
		v, SLOT(handleToggle(QListViewItem *)));
	connect(lv, SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &, int)),
		v, SLOT(handleRightClick(QListViewItem *, const QPoint &, int)));
	connect(lv, SIGNAL(clicked(QListViewItem *)),
		v, SLOT(refreshCommentTextEdit(QListViewItem *)));
	connect(lv, SIGNAL(mouseButtonClicked(int, QListViewItem *, const QPoint &, int)),
		v, SLOT(mouseButtonClicked(int, QListViewItem *, const QPoint &, int)));
	connect(lv, SIGNAL(doubleClicked(QListViewItem *, const QPoint &, int)),
		v, SLOT(mouseButtonDoubleClicked(QListViewItem *, const QPoint &, int)));
	lv->addColumn(i18n("Description"), 180);
	lv->addColumn(i18n("Username"), 150);
	lv->addColumn(i18n("Password"), 150);
	lv->addColumn(i18n("URL"), 180);
	lv->addColumn(i18n("Launcher"), 120);
	v->tmpReEnableSort();
	resizeView(v->size());
	v->updateView();
	if (wasMaximized) {
		v->showMaximized();
	} else {
		v->show();
	}
	connect(lv, SIGNAL(layoutChanged()),
		v, SLOT(reorgLp()));
}

void PwMViewStyle::resizeView(const QSize &size)
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		s0->resize(size);
		return;
	case style_1:
		PWM_ASSERT(s1);
		s1->resize(size);
		return;
	default:
		BUG();
	}
}

QString PwMViewStyle::getCurrentCategory()
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		return s0->getCurrentCategory();
	case style_1:
		PWM_ASSERT(s1);
		return s1->getCurrentCategory();
	default:
		BUG();
	}
	return "";
}

void PwMViewStyle::addCategory(const QString &cat)
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		s0->addCategory(cat);
		return;
	case style_1:
		PWM_ASSERT(s1);
		s1->addCategory(cat);
		return;
	default:
		BUG();
	}
}

void PwMViewStyle::delCategory(const QString &cat)
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		s0->delCategory(cat);
		return;
	case style_1:
		PWM_ASSERT(s1);
		s1->delCategory(cat);
		return;
	default:
		BUG();
	}
}

void PwMViewStyle::delAllCategories()
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		s0->delAllCategories();
		return;
	case style_1:
		PWM_ASSERT(s1);
		s1->delAllCategories();
		return;
	default:
		BUG();
	}
}

void PwMViewStyle::selectCategory(const QString &cat)
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		s0->selectCategory(cat);
		return;
	case style_1:
		PWM_ASSERT(s1);
		s1->selectCategory(cat);
		return;
	default:
		BUG();
	}
}

int PwMViewStyle::numCategories()
{
	switch (curStyle) {
	case style_0:
		PWM_ASSERT(s0);
		return s0->numCategories();
	case style_1:
		PWM_ASSERT(s1);
		return s1->numCategories();
	default:
		BUG();
	}
	return 0;
}

#include "pwmviewstyle.moc"
