/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_MASTERKEY_SMARTKEY_H_
#define PWMANAGER_MASTERKEY_SMARTKEY_H_

#include "masterkey/smartkey/smartkey_backend.h"

#include <qobject.h>
#include <qcstring.h>


#define MIN_SMARTCARD_SIZE	256 /* 256 byte == 2 kBit */


class QWidget;
class PwM;

/** Interface class for SmartCard as MasterKey. */
class SmartKey : public QObject
{
	Q_OBJECT

	friend class SmartKey_backend;

public:
	SmartKey(QWidget *_parent, PwM *_mainwnd = 0);
	~SmartKey();

	/** read the key from the card. */
	bool requestKey(QByteArray *key);
	/** generate a new key and write it to the card. */
	bool genKey(QByteArray *key = 0);
	/** erase the card. */
	bool eraseCard();
	/** export to KeyFile. */
	bool exportToKeyFile();
	/** import from KeyFile. */
	bool importFromKeyFile();
	/** display the smartkey ID. */
	void displayKeyId();

protected:
	/** display an error message based on the status ID. */
	void displayStatusMsg(SmartKey_backend::Status status);
	/** display "stream corrupt" message. */
	void displayCorruptStreamMsg();
	/** print a status bar message, if a mainwindow is available. */
	void statusBarMsg(const QString &msg);

protected:
	/** Parent widget. */
	QWidget *parent;
	/** Main window. */
	PwM *mainwnd;
	/** card access backend. */
	SmartKey_backend *backend;
};

#endif // PWMANAGER_MASTERKEY_SMARTKEY_H_
