/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "configuration_31compat.h"
#include "configwndimpl.h"
#include "pwmexception.h"

#include <kconfig.h>
#include <kapplication.h>

#include <qfileinfo.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qlabel.h>


Configuration_31compat * Configuration_31compat::_obj (0);

Configuration_31compat::Configuration_31compat()
{
	conf = KApplication::kApplication()->config();
}

Configuration_31compat::~Configuration_31compat()
{
}

bool Configuration_31compat::showConfWnd(QWidget * /*parent*/)
{
	ConfigWndImpl cfgWnd;
	cfgWnd.pwTimeoutSpinBox->setValue(confGlobPwTimeout());
	cfgWnd.lockTimeoutSpinBox->setValue(confGlobLockTimeout());
	cfgWnd.trayCheckBox->setChecked(confGlobTray());
	cfgWnd.autoStartLineEdit->setText(confGlobAutoStart());
	cfgWnd.openUnlockedCheckBox->setChecked(confGlobUnlockOnOpen());
	cfgWnd.currentEntryFont = confGlobEntryFont();
	cfgWnd.currEntrFont->setText(cfgWnd.currentEntryFont.family());
	cfgWnd.currEntrFont->setFont(cfgWnd.currentEntryFont);
	cfgWnd.windowStyleComboBox->setCurrentItem(confWndMainViewStyle());
	cfgWnd.compressionComboBox->setCurrentItem(confGlobCompression());
	cfgWnd.autoMinimizeCheckBox->setChecked(confWndAutoMinimizeOnStart());
	cfgWnd.browserLineEdit->setText(confGlobBrowserCommand());
	cfgWnd.xtermLineEdit->setText(confGlobXtermCommand());
	cfgWnd.setFilePermissions(confGlobFilePermissions());
	cfgWnd.fileBackupCheckBox->setChecked(confGlobMakeFileBackup());
	cfgWnd.autostartDeeplockedCheckBox->setChecked(confGlobAutostartDeepLocked());
	cfgWnd.autoDeepLockCheckBox->setChecked(confGlobAutoDeepLock());
	cfgWnd.minimizeLockComboBox->setCurrentItem(confGlobMinimizeLock());
	cfgWnd.wndCloseCheckBox->setChecked(confWndClose());
#ifdef CONFIG_KWALLETIF
	cfgWnd.kwalletEmuCheckBox->setChecked(confGlobKwalletEmu());
#else // CONFIG_KWALLETIF
	cfgWnd.kwalletEmuCheckBox->setChecked(false);
	cfgWnd.kwalletEmuCheckBox->setEnabled(false);
#endif // CONFIG_KWALLETIF

	if (cfgWnd.exec())
		return false;

	confGlobPwTimeout(cfgWnd.pwTimeoutSpinBox->value());
	confGlobLockTimeout(cfgWnd.lockTimeoutSpinBox->value());
	confGlobTray(cfgWnd.trayCheckBox->isChecked());
	confGlobAutoStart(cfgWnd.autoStartLineEdit->text());
	confGlobUnlockOnOpen(cfgWnd.openUnlockedCheckBox->isChecked());
	confGlobEntryFont(cfgWnd.currentEntryFont);
	confWndMainViewStyle(cfgWnd.windowStyleComboBox->currentItem());
	confGlobCompression(cfgWnd.compressionComboBox->currentItem());
	confWndAutoMinimizeOnStart(cfgWnd.autoMinimizeCheckBox->isChecked());
	confGlobBrowserCommand(cfgWnd.browserLineEdit->text());
	confGlobXtermCommand(cfgWnd.xtermLineEdit->text());
	confGlobFilePermissions(cfgWnd.getFilePermissions());
	confGlobMakeFileBackup(cfgWnd.fileBackupCheckBox->isChecked());
	confGlobAutostartDeepLocked(cfgWnd.
				autostartDeeplockedCheckBox->isChecked());
	confGlobAutoDeepLock(cfgWnd.autoDeepLockCheckBox->isChecked());
	confGlobMinimizeLock(cfgWnd.minimizeLockComboBox->currentItem());
	confWndClose(cfgWnd.wndCloseCheckBox->isChecked());
#ifdef CONFIG_KWALLETIF
	confGlobKwalletEmu(cfgWnd.kwalletEmuCheckBox->isChecked());
#endif // CONFIG_KWALLETIF
	return true;
}

/*******************************************************************
 *  functions for reading the configuration settings
 *******************************************************************/

QString Configuration_31compat::confGlobAutoStart()
{
	conf->setGroup("GLOBAL");
	return conf->readEntry("autoStart");
}

QString Configuration_31compat::confGlobBrowserCommand()
{
	conf->setGroup("GLOBAL");
	return conf->readEntry("browserCommand", CONF_DEFAULT_BROWSERCOMMAND);
}

QString Configuration_31compat::confGlobXtermCommand()
{
	conf->setGroup("GLOBAL");
	return conf->readEntry("xtermCommand", CONF_DEFAULT_XTERMCOMMAND);
}

QFont Configuration_31compat::confGlobEntryFont()
{
	conf->setGroup("GLOBAL");
	return conf->readFontEntry("entryFont");
}

int Configuration_31compat::confGlobPwTimeout()
{
	conf->setGroup("GLOBAL");
	return conf->readNumEntry("pwTimeout", CONF_DEFAULT_PWTIMEOUT);
}

int Configuration_31compat::confGlobLockTimeout()
{
	conf->setGroup("GLOBAL");
	return conf->readNumEntry("lockTimeout", CONF_DEFAULT_LOCKTIMEOUT);
}

int Configuration_31compat::confGlobCompression()
{
	conf->setGroup("GLOBAL");
	return conf->readNumEntry("compression", CONF_DEFAULT_COMPRESSION);
}

int Configuration_31compat::confGlobFilePermissions()
{
	conf->setGroup("GLOBAL");
	return conf->readNumEntry("filePermissions", CONF_DEFAULT_FILEPERMISSIONS);
}

int Configuration_31compat::confGlobMinimizeLock()
{
	conf->setGroup("GLOBAL");
	return conf->readNumEntry("minimizeLock", CONF_DEFAULT_MINIMIZELOCK);
}

bool Configuration_31compat::confGlobUnlockOnOpen()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("unlockOnOpen", CONF_DEFAULT_UNLOCKONOPEN);
}

bool Configuration_31compat::confGlobTray()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("tray", CONF_DEFAULT_TRAY);
}

bool Configuration_31compat::confGlobMakeFileBackup()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("makeFileBackup", CONF_DEFAULT_MAKEFILEBACKUP);
}

bool Configuration_31compat::confGlobAutostartDeepLocked()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("autostartDeeplocked", CONF_DEFAULT_AUTOSTART_DEEPL);
}

bool Configuration_31compat::confGlobAutoDeepLock()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("autoDeepLock", CONF_DEFAULT_AUTODEEPLOCK);
}

bool Configuration_31compat::confGlobKwalletEmu()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("kwalletEmu", CONF_DEFAULT_KWALLETEMU);
}

bool Configuration_31compat::confGlobNewEntrLockStat()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("newEntrLockStat", CONF_DEFAULT_NEWENTRLOCKSTAT);
}

bool Configuration_31compat::confGlobCanExecAsRoot()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("canExecAsRoot", CONF_DEFAULT_ALLOWROOTEXEC);
}

bool Configuration_31compat::confGlobBase64Storage()
{
	conf->setGroup("GLOBAL");
	return conf->readBoolEntry("base64Storage", CONF_DEFAULT_BASE64STORAGE);
}

QSize Configuration_31compat::confWndMainWndSize()
{
	conf->setGroup("WND");
	return conf->readSizeEntry("MainWndSize");
}

int Configuration_31compat::confWndMainViewStyle()
{
	conf->setGroup("WND");
	return conf->readNumEntry("MainViewStyle", CONF_DEFAULT_MAINVIEWSTYLE);
}

bool Configuration_31compat::confWndAutoMinimizeOnStart()
{
	conf->setGroup("WND");
	return conf->readBoolEntry("autoMinimizeOnStart", CONF_DEFAULT_AUTOMINIMIZE);
}

bool Configuration_31compat::confWndClose()
{
	conf->setGroup("WND");
	return conf->readBoolEntry("close", CONF_DEFAULT_WNDCLOSE);
}

/*******************************************************************
 *  functions for writing the configuration settings
 *******************************************************************/

void Configuration_31compat::confGlobAutoStart(const QString &e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("autoStart", e);
}

void Configuration_31compat::confGlobBrowserCommand(const QString &e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("browserCommand", e);
}

void Configuration_31compat::confGlobXtermCommand(const QString &e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("xtermCommand", e);
}

void Configuration_31compat::confGlobEntryFont(const QFont &e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("entryFont", e);
}

void Configuration_31compat::confGlobPwTimeout(int e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("pwTimeout", e);
}

void Configuration_31compat::confGlobLockTimeout(int e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("lockTimeout", e);
}

void Configuration_31compat::confGlobCompression(int e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("compression", e);
}

void Configuration_31compat::confGlobFilePermissions(int e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("filePermissions", e);
}

void Configuration_31compat::confGlobMinimizeLock(int e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("minimizeLock", e);
}

void Configuration_31compat::confGlobUnlockOnOpen(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("unlockOnOpen", e);
}

void Configuration_31compat::confGlobTray(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("tray", e);
}

void Configuration_31compat::confGlobMakeFileBackup(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("makeFileBackup", e);
}

void Configuration_31compat::confGlobAutostartDeepLocked(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("autostartDeeplocked", e);
}

void Configuration_31compat::confGlobAutoDeepLock(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("autoDeepLock", e);
}

void Configuration_31compat::confGlobKwalletEmu(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("kwalletEmu", e);
}

void Configuration_31compat::confGlobNewEntrLockStat(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("newEntrLockStat", e);
}

void Configuration_31compat::confGlobCanExecAsRoot(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("canExecAsRoot", e);
}

void Configuration_31compat::confGlobBase64Storage(bool e)
{
	conf->setGroup("GLOBAL");
	conf->writeEntry("base64Storage", e);
}

void Configuration_31compat::confWndMainWndSize(const QSize &e)
{
	conf->setGroup("WND");
	conf->writeEntry("MainWndSize", e);
}

void Configuration_31compat::confWndMainViewStyle(int e)
{
	conf->setGroup("WND");
	conf->writeEntry("MainViewStyle", e);
}

void Configuration_31compat::confWndAutoMinimizeOnStart(bool e)
{
	conf->setGroup("WND");
	conf->writeEntry("autoMinimizeOnStart", e);
}

void Configuration_31compat::confWndClose(bool e)
{
	conf->setGroup("WND");
	conf->writeEntry("close", e);
}
