"""This file contains the Device class."""

import Const
from qt import QListViewItem, QPixmap
from kdeui import KListViewItem

class Device:
	def __init__(self, device_name, parent_name, properties):
		self.device_name = device_name
		self.parent_name = parent_name
		self.parent_device = None
		self.properties = properties
		self.children = []
	
	def print_tree(self, indent):
		if indent==0:
			print " "*indent + self.device_name
		else:
			print " "*indent + "- " + self.device_name
		for c in self.children:
			c.print_tree(indent+4)
	
	def populate_qt_tree(self, parent_item, dont_show_virtual, representation):
		# see if we should show virtual devices
		if dont_show_virtual:
			try:
				if self.properties["info.virtual"]:
				# do show all block devices, ide channels
					if not self.properties["info.bus"] in ["block", "ide_host"]:
						self.row = self.parent_device.row
						# and recurse the childs
						for c in self.children:
							c.populate_qt_tree(parent_item,
									dont_show_virtual,
									representation)
						return
			except:
				pass
		try:
			title_name = self.properties["info.product"]
		except KeyError:
			title_name = "Unknown Device"
		except TypeError:
			title_name = "Unknown Device"
        	if self.parent_device==None:
			#listViewItem = QListViewItem(parent_item, "empty")
			listViewItem = parent_item
        	else:
			listViewItem = KListViewItem(parent_item, title_name, self.device_name)
			listViewItem.setOpen(True)
			listViewItem.setPixmap(Const.TITLE_COLUMN, representation.get_icon(self) )
			
		for c in self.children:
			c.populate_qt_tree(listViewItem,
					dont_show_virtual,
					representation)
	
	def find_by_udi(self, device_udi):
		if self.device_name==device_udi:
			return self
		for c in self.children:
			rc = c.find_by_udi(device_udi)
			if rc!=None:
				return rc
		return None
