/***************************************************************************
                          kconfigure.h  -  description
                             -------------------
    begin                : s� ene  6 16:35:16 CET 2001
    copyright            : (C) 2001-2005 by Javier Campos Morales & the Kconfigure Team
    email                : kconfigure@rockerssoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONFIGURE_H
#define KCONFIGURE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kurl.h>
#include <kaction.h>
#include <kstdaction.h>
#include <knotifyclient.h>

#include "konq_actions.h"

#include <qdir.h>
#include <qmultilineedit.h>
#include <qsplitter.h>
#include <qdatetime.h>
#include <kio/job.h>

/**Main Function

  *@author Robert Rockers
  */

class Kconfigure : public KMainWindow
{
  Q_OBJECT
  public:
	/** construtor */
	Kconfigure(QWidget *parent=0, const char *name=0, WFlags f=WDestructiveClose);
	/** destructor */
	~Kconfigure();
	/** Set action menues */
	void setActionMode( bool isRun, bool stop);
private: // Private methods
	/** Init main window */
	void init();
	/** Open with extract operation */
	bool openExtractURL(const KURL &kurl, const QString &extVal);
	/** Init the menu bar */
	void setupMenuBar();
	/** Read the config */
	void configRead();
	/** Write the settings */
	void configWrite();
	/** Execute a command file */
	void execute(const char *file);
	/** Open file in main window */
	void openViewFile( const QString &filename );
	/** No descriptions */
	void headerHTML( const QString &command );
	/** Stop time and print into log */
	void stop_time();
private: // Private attributes
	/** Main errors is view by a list box to support select errors and view files. */
	QMultiLineEdit *view_errors;
	/** Indicate if there are a fatal error when the process is finish */
	bool FatalError;
	/** Main view text view */
	QMultiLineEdit *view_main;
	/** The main process */
	KShellProcess q;
	/** Main directory */
	QDir qDir;
	/** Line to stream into the QTextView */
	QString streamLine;
	/** File name */
	QString fileName;
	/** File path */
	QString filePath;
	/** Recent files */
	KRecentFilesAction *recentFiles;
	/** Our install options menu selection */
	KSelectAction *actionInstallWhich;
	/** Main Splitter */
	QSplitter *s1;
	/** File README */
	QString file_README;
	/** File INSTALL */
	QString file_INSTALL;
	/** File CHANGELOG */
	QString file_CHANGELOG;
	/** Show menu bar */
	KToggleAction *toolbarAction;
	/** Action menu README */
	KAction *actionfilemenu_README;
	/** Action menu INSTALL */
	KAction *actionfilemenu_INSTALL;
	/** Action menu CHANGELOG */
	KAction *actionfilemenu_CHANGELOG;
	/** Action start log */
	KToggleAction *filemenu_start_log;
	/** Des/Activate start log */
	bool logOn;
	/** Log format */
	bool logHtml;
	/** Save log in this string */
	QString logString;
	/** Timer */
	QTime time;
	/** Animated logo */
	KonqLogoAction *AnimatedLogo;
	/**  Menu actions */
	KAction *actionStop;
	KAction *actionQmake;
	KAction *actionQmakeArg;
	KAction *actionConfigure;
	KAction *actionConfigureHelp;
	KAction *actionConfigureArg;
	KAction *actionMake;
	KAction *actionMakeClean;
	KAction *actionMakeArg;
	KAction *actionInstall;

private slots: // Private slots
	/** Set the which install option to the config */
	void slotSelectInstall();
	/** Quit the kconfigure program */
	void slotMenuQuit();
	/** Toggle Toolbar */
	void slotMenuToggleToolBar();
	/** Configure Toolbar */
	void slotMenuConfigureToolbar();
	/** Configure keys */
	void slotMenuConfigureKeys();
	/** Output the exec output */
	void slotOutputMessages(KProcess*,char* buffer,int buflen);
	/** Output the messages error */
	void slotOutputMessagesError(KProcess*,char* buffer,int buflen);
	/** Execute configure */
	void slotExecuteConfigure();
	/** Execute Qmake */
	void slotExecuteQmake();
	/** Qmake with arguments */
	void slotExecuteQmake_Args();
	/** Finish the process */
	void slotFinishAction();
	/** Configure --help */
	void slotExecuteConfigure_Help();
	/** Configure with arguments */
	void slotExecuteConfigure_Args();
	/** Execute make with arguments */
	void slotExecuteMake_Args();
	/** Execute make */
	void slotExecuteMake();
	/** Make clean */
	void slotExecuteMake_Clean();
	/** Our install option selection action */
	void slotSetInstallOption();
	/** Execute our selected Install program */
	void slotSelectExecuteInstall();
	/** Make install */
	void slotExecuteInstall();
	/** Make Root install */
	void slotExecuteInstallRoot();
	/** Make root checkinstall */
	void slotExecuteCheckInstallRoot();
	/** Open Terminal Window in Application space */
	void slotOpenTerminal();
	/** Kill the process */
	void slotKillProcess();
	/** Configure dialog */
	void slotMenuConfigure();
	/** Clear output text */
	void slotClearMain();
	void slotClearError();
	void slotClearAll();
	/** View README file */
	void slotReadREADME();
	/** View INSTALL file */
	void slotReadINSTALL();
	/** View ChangeLog file */
	void slotReadCHANGELOG();
	/** Log options */
	void slotLogStart();
	void slotLogView();
	void slotLogClear();
	void slotLogSave();
	/** Open new URL */
	void openURLnew();
	/** Result compress */
	void slotResult( KIO::Job *job);
protected: // Protected methods
	/** Exit the program */
	bool queryExit();
public slots: // Public slots
	/** Open file */
	void openURL( const KURL &url );
};

#endif
