/***************************************************************************
                         kscriptadd.cpp  -  script add dialog
                         -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qradiobutton.h>

#include <klocale.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kactivelabel.h>
#include <kmessagebox.h>

#include "kscriptadd.h"


KScriptAdd::KScriptAdd(QWidget *parent, char *name, bool modal)
  : KDialogBase(Plain, i18n("Script Add"), Help|Ok|Cancel,
                Ok, parent, name, modal, true)
{
  // TODO: write and set the proper link to documentation
  setHelp("kcmpureftpdscript/index.html", QString::null);

  scriptAdd = new ScriptAdd(plainPage());
  QVBoxLayout *vlayout = new QVBoxLayout(plainPage(), 0, spacingHint());
  vlayout->addWidget(scriptAdd);

  connect(scriptAdd, SIGNAL(configChanged()), this, SLOT(slotChanged()));
  enableButton(Ok, false);
  configChanged=false;
}

void KScriptAdd::setData(ScriptPref p)
{
  scriptAdd->outputFile->setURL(p.outputfile);
  outputfilemode=p.outputfilemode;
  enableButton(Ok, false);
  configChanged=false;
}

void KScriptAdd::setInfo(const QString &s)
{
  scriptAdd->infoLabel->setText(s);
}

void KScriptAdd::slotChanged()
{
  enableButton(Ok, true);
  configChanged=true;
}

void KScriptAdd::slotOk()
{
  if (getData()) {
    accept();
  }
}

void KScriptAdd::slotApply()
{
  getData();
}

bool KScriptAdd::getData()
{
  QString title = scriptAdd->title->text();
  QString description = scriptAdd->description->text();
  QString outputfile = scriptAdd->outputFile->url();

  title=title.stripWhiteSpace();
  description=description.stripWhiteSpace();
  outputfile=outputfile.stripWhiteSpace();
  scriptAdd->title->setText(title);
  scriptAdd->description->setText(description);
  scriptAdd->outputFile->setURL(outputfile);

  if (title.isEmpty()) {
    KMessageBox::sorry(this,i18n("You must enter a name for the new script."),i18n("Empty Script Name"));
    return false;
  } else if (title.length() > MAXTITLE) {
    KMessageBox::sorry(this,i18n("Script name length cannot exced %1 characters.").arg(MAXTITLE),i18n("Name Too Long"));
    return false;
  } else if (description.length() > MAXDESCRIPTION) {
    KMessageBox::sorry(this,i18n("Description length cannot exced %1 characters.").arg(MAXDESCRIPTION),i18n("Description too long"));
    return false;
  } else {
    ScriptPref tmpPref;

    tmpPref.title=title;
    tmpPref.description=description;
    tmpPref.outputfile=outputfile;
    tmpPref.outputfilemode=outputfilemode;

    emit setPref(tmpPref);
    enableButton(Ok, false);
    configChanged=false;
  }

  return true;
}
