/*
 * nvviewlistitem.cpp
 *
 *  Copyright (C) 2007 Jürgen Heinemann <undefined(AT)users(DOT)berlios(dot)de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "nvviewlistitem.h"

#include <qfile.h>
#include <qfileinfo.h>
#include <qregexp.h>
#include <qdom.h>

#include <klocale.h>
#include <kstandarddirs.h>

nvviewlistitem::nvviewlistitem( QWidget* parent, const char* name, const char* path )
                : KListView( parent, name )
{
        addColumn( tr2i18n( "parameter" ) );
        addColumn( tr2i18n( "value" ) );
        addColumn( tr2i18n( "description" ) );
        setSelectionModeExt( KListView::FileManager );
        setResizeMode( QListView::AllColumns );
        setShadeSortColumn( true );

        QString ProcPath( "/proc/driver/nvidia/" );
        ProcPath.append( path );

        attrKey = path;

        QFile file( ProcPath );
        if ( file.open( IO_ReadOnly ) ) {
                char buf[512];
                while ( file.readLine( buf, sizeof( buf ) - 1 ) > 0 ) {
                        insertItem( SlotSetRowEntry( buf ) );
                }
                file.close();
        }
}

QString nvviewlistitem::getDescription( QString &node )
{
        QString Output;
        KStandardDirs m_KStandardDirs;
        QString path = m_KStandardDirs.findResource( "data", "kcontrol/xml/kcmnvview.xml" );
        QFileInfo check( path );
        if ( check.exists() ) {
                QFile xmlFile( path );
                if ( ! xmlFile.open( IO_ReadOnly ) )
                        return QString::null;

                QDomDocument *dom = new QDomDocument( QString( "kcmnvview" ) );
                if ( ! dom->setContent( &xmlFile ) ) {
                        xmlFile.close();
                        return QString::null;
                }

                QDomNodeList FileNodes = dom->elementsByTagName( QString( "file" ) );
                int FileNodesLength = FileNodes.count();
                for ( int i = 0; i < FileNodesLength; i++ ) {
                        QDomElement BufferElement = FileNodes.item( i ).toElement();
                        if ( BufferElement.hasAttribute( "key" )
                                        && BufferElement.attributeNode( "key" ).value() == attrKey ) {
                                QDomNodeList ItemNodes = BufferElement.elementsByTagName( QString( "item" ) );
                                int ItemNodesLength = ItemNodes.count();
                                for ( int j = 0; j < ItemNodesLength; j++ ) {
                                        QDomElement DescElement = ItemNodes.item( j ).toElement();
                                        if ( DescElement.hasAttribute( "key" )
                                                        && DescElement.attributeNode( "key" ).value() == node ) {
                                                Output = DescElement.firstChild().nodeValue();
                                                break;
                                        }
                                }
                        }
                }
                xmlFile.close();
                return Output;
        } else
                return QString::null;
}

KListViewItem* nvviewlistitem::SlotSetRowEntry( const char* item )
{
        QRegExp reg( ":[\\s\\t]+" );
        QStringList vals = QStringList::split( reg, QString::fromLatin1( item ) );
        return new KListViewItem( this, vals.first(), vals.last(), getDescription( vals.first() ) );
}

nvviewlistitem::~nvviewlistitem()
{}

#include "nvviewlistitem.moc"
