/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef WEBLOGSTYLEGETTER_H
#define WEBLOGSTYLEGETTER_H
#include <QObject>
#include <QByteArray>
#include <QString>

/**
 * This class will
 *  1. Create a temporary post
 *  2. Send post
 *  3. Read the post url
 *  4. Get & Save the html page
 */

namespace KIO
{
class Job;
}
class KJob;

namespace KBlogger
{

class KBloggerPost;

class WeblogStyleGetter: public QObject
{
    Q_OBJECT
public:
    WeblogStyleGetter(const QString& blog, QObject *parent);
    ~WeblogStyleGetter();

    //Returns
    static QString styledHtml(const QString& blogname,
                              const QString& title,
                              const QString& content);
Q_SIGNALS:
    void styleFetched();

private Q_SLOTS:
    void slotPostSent();
    void slotPostFetched();
    void slotHtmlCopied(KJob *job);

private:
    void generateRandomPostStrings();

    KBloggerPost *tempPost;
    QString cachePath;

    KIO::Job *httpGetJob;
    QByteArray httpData;
    QString httpMimeType;

    QString postTitle;
    QString postContent;

    QWidget *mParent;
};

}; //namespace
#endif
