/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "visualeditor.h"

#include <QList>
#include <QUrl>
#include <QFile>

#include <kdebug.h>

#include "itemsmanager.h"

namespace KBlogger
{
VisualEditor::VisualEditor(QWidget *parent): KTextEdit(parent)
{
    kDebug();
    setAcceptDrops(true);
}

VisualEditor::~VisualEditor()
{
    kDebug();
}

QVariant VisualEditor::loadResource ( int type, const QUrl & name )
{
    kDebug() << type << name;
    //TODO remove: Why not use the uploadmediadialog for all?
    if ( type != QTextDocument::ImageResource) return QVariant();

    QByteArray data;
    data = ItemsManager::self()->mediaData(name); //TODO
    if ( !data.count() ) {
        kError() << "Data is NULL";
        return QVariant();
    }
    QVariant dataV(data);
    return dataV;
}

void VisualEditor::dragEnterEvent(QDragEnterEvent *event)
{
    kDebug();
    //if (event->mimeData()->hasFormat("text/plain"))
    const QMimeData *mimeData = event->mimeData();
    if (mimeData->hasColor()) return;
    if (mimeData->hasImage ()) return;
    event->acceptProposedAction();
}

void VisualEditor::dropEvent(QDropEvent *event)
{
    kDebug();
    const QMimeData *mimeData = event->mimeData();

    if ( mimeData->hasUrls() ) {
        QList<QUrl> urls;
        urls = mimeData->urls();
        for (int i = 0; i < urls.count() && i < 32; ++i) {
            QString url = urls.at(i).path();
            if (!url.isEmpty()) {
                emit droppedMedia(url);
            }
        }
    } else
        if ( mimeData->hasText() ) {
            insertHtml( mimeData->html() );
        } else
            if (mimeData->hasText()) {
                insertPlainText(mimeData->text());
            } else {
                return;
            }
    //ComposerTabWidget->setCurrentIndex(0);
    event->acceptProposedAction();
}

}

#include "visualeditor.moc"

