/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "backendjobsqueue.h"
#include "backend.h"

#include <kdebug.h>
#include <kjob.h>

#include "backendjobs.h"
#include "waitwidget.h"

namespace KBlogger
{

class BackendJobsQueue_p
{
public:
    // TODO how can a job be running and stopped at the same time ??? hacked for the moment
    // as this breaks cancelling, because it stops the job and tells the next time you start one, that
    // it is already running.
    BackendJobsQueue_p(): mStop(false), mRunning(false) {
        kDebug();
    };

    ~BackendJobsQueue_p() {};

    void setStop(bool value) {
        mStop = value;
        mRunning = !value;
    };

    bool isStopped() {
        return mStop;
    }

    void setRunning(bool value) {
        mRunning = value;
        mStop = !value;
    }

    bool isRunning() {
        return mRunning;
    }

private:
    bool mStop;
    bool mRunning;
};



BackendJobsQueue::BackendJobsQueue(QObject *parent): QObject(parent),
        currentJob(0), mWaitWidget(0)
{
    kDebug();

    d = new BackendJobsQueue_p();
}

BackendJobsQueue::~BackendJobsQueue()
{
    kDebug();
}

bool BackendJobsQueue::addJob( BackendJobs* job )
{
    kDebug();

    if (d->isRunning()) {
        kError() << "This job cannot be queued while other jobs are running" << endl;
        return false;
    }
    mPendingJobs << job;
    return true;
}

void BackendJobsQueue::run()
{
    kDebug();
    if (d->isRunning()) {
        kError() << "Jobs run already" << endl;
        return;
    }
    emit jobsStarted(mPendingJobs.count());
    d->setRunning(true);

    runsFirstJob();
}

bool BackendJobsQueue::stop()
{
    kDebug();

// TODO check if this is necessary??
//     if (d->isStopped()) {
//         kDebug() << "mStop is already TRUE";
//         return false;
//     }
    d->setStop(true);
    return true; //ok, queue stopped.
}


void BackendJobsQueue::clear()
{
    kDebug();
    mPendingJobs.clear();
}

/*
bool BackendJobsQueue::killCurrentJob()
{
   kDebug();
   if ( !d->isRunning() ) return false;
   d->setRunning(false);
   if ( currentJob )
     return currentJob->kill();
   else
     return false;
}
*/

bool BackendJobsQueue::isRunning()
{
    kDebug();
    return d->isRunning();
}

int BackendJobsQueue::queueSize()
{
    kDebug();
    return mPendingJobs.size();
}

void BackendJobsQueue::runsFirstJob()
{
    kDebug();
    if ( d->isStopped() ) {
        emit jobsStopped();
        d->setRunning(false);
        d->setStop(false);
        hideWaitWidget();
        return;
    }

    if (!mPendingJobs.isEmpty()) {
        currentJob = mPendingJobs.takeFirst();
        QString message = i18np("1 job left", "%1 jobs left", mPendingJobs.count());
        Backend::self()->showStatusBarMessage(message);
        Q_ASSERT(currentJob);
        showUpdatedWaitWidget( currentJob->getWaitMessage(),
                               currentJob->getWidgetParent() );
        connect(currentJob, SIGNAL( result( KJob * ) ),
                this, SLOT( slotResult( KJob * ) ) );
        currentJob->start();
    } else {
        hideWaitWidget();
        d->setRunning(false);
        emit jobsDone();
    }
}

void BackendJobsQueue::slotResult( KJob * kjob)
{
    kDebug();
    currentJob->disconnect( );
    emit jobDone();
    runsFirstJob();
    //Q_UNUSED(kjob);
    BackendJobs* job;
    job = qobject_cast<BackendJobs*>(kjob);
    if ( kjob->error() ) {
        // An error occurred
        emit jobsDone();
        hideWaitWidget();
        d->setRunning(false);
    }
}

//WaitWidget functions
void BackendJobsQueue::showUpdatedWaitWidget( const QString& text, QWidget* caller )
{
    kDebug();

    mWaitWidget = WaitWidget::self(caller);

    kDebug()  << text << mWaitWidget;

    Q_ASSERT(mWaitWidget);

    mWaitWidget->update( text, caller );
    mWaitWidget->show();
}

void BackendJobsQueue::hideWaitWidget()
{
    kDebug();
    delete mWaitWidget;
}

}

#include "backendjobsqueue.moc"

