/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BACKEND_JOBS_H
#define BACKEND_JOBS_H

#include <QList>
#include <QVariant>
#include <QWidget>

#include <kblog/blog.h>
#include <kjob.h>

#include "kbloggerblog.h"

class KBlog::BlogPost;
class KBlog::BlogMedia;

namespace KBlogger
{

class Backend;
class ItemsManager;

class BackendJobs : public KJob
{
    Q_OBJECT

public:
    enum BlogActions { LIST_RECENT_POSTS, FETCH_POST, MODIFY_POST,
                       CREATE_POST, REMOVE_POST, FETCH_CATEGORIES, CREATE_MEDIA
                     };

    BackendJobs( KBloggerBlog kbBlog, BlogActions action, QVariant arg,
                 QWidget *WaitWidgetParent = 0, QObject* parent = 0 );

    virtual  ~BackendJobs();

    void start();
    void createBackend(KBloggerBlog *kbBlog);
    QWidget* getWidgetParent() {
        return mWaitWidgetParent;
    }
    const QString& getWaitMessage();

private Q_SLOTS:
    void slotExitSuccess();
    void slotExitError( KBlog::Blog::ErrorType type, const QString& message);

    void slotListedRecentPosts( const QList<KBlog::BlogPost>& posts);
    void slotListedCategories( const QList<QMap<QString, QString> >& categories );
    void slotCreatedPost( KBlog::BlogPost *post);
    void slotRemovedPost( KBlog::BlogPost * post);
    void slotFetchedPost( KBlog::BlogPost *post);
    void slotModifiedPost( KBlog::BlogPost *post);
    void slotCreatedMedia( KBlog::BlogMedia* media);

private:
    BlogActions mAction;
    QVariant mArg;
    KBloggerBlog mKBlogInfo;
    Backend *mBackend;
    ItemsManager *mItemsManager;
    QWidget *mWaitWidgetParent;
    KBlog::Blog* mKBlog;
    QList<QVariant> mResults;
    QString mWaitMessage;

};

}//Namespace

#endif

