//
// C++ Interface: arxivsearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SPIRESSEARCHER_H
#define SPIRESSEARCHER_H

#include "searcher.h"
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>
#include <qmap.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/

class KComboBox;

class SpiresSearcher;

class SpiresConfigWidget : public SearcherConfigWidget {
	public:
		SpiresConfigWidget(QWidget* parent, SpiresSearcher* searcher = 0);
		virtual void updateSearcher();
	private:
		KComboBox* m_mirrorCombo;
};

class SpiresSearcher : public searcher
{
Q_OBJECT
	public:
		SpiresSearcher(QObject* parent, const char* name=0);
		
		virtual ~SpiresSearcher();

		virtual QString source() const;
		virtual void setSource(const QString );
		virtual QString helpURL() {return QString::fromLatin1("http://www.slac.stanford.edu/spires/hep/help")  ; }
		virtual bool isSearching() const { return m_started; }
		virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
		virtual void search(QString queryString);
		virtual void stop();
		virtual Type type() const { return Spires; }
		virtual void readConfig(KConfig* config, const QString& group);
		virtual void saveConfig(KConfig* config);
		virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
		friend class SpiresConfigWidget;
		virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
		virtual void retrieveRange(unsigned int min, unsigned int max);
		virtual QStringList searchKey();
		virtual int maxSearchTerms() {return 100; }
		static QString defaultName();

	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);

	private:
		void searchResults();
		void fetchResults();

		enum Step {
			Begin,
			Search,
			Wait,
			Fetch
		};

		KURL m_url;
		QByteArray m_data;
		QString m_query;
		int m_total;
		QString m_queryKey;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;
		QString m_mirror;
		static QMap<QString,QString> mirror_map;
		QString SPIRES_BASE_URL;
};

#endif
