/***************************************************************************
                          kbibsortdlg  -  description
                             -------------------
    begin                : Fri Nov 26 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbibsortdlg.h"
#include "bibentrydeftable.h"

#include <kiconloader.h>
#include <klocale.h>
#include <qpixmap.h>

#include <qlayout.h>
#include <qhbox.h>
#include <qvbox.h>

#include <string>
#include <vector>
using namespace std;


KBibSortDlg::KBibSortDlg(QWidget *parent, const char *name)
    :KDialogBase( parent, name , true, i18n("Sort references"), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());


  label = new QLabel(i18n("Field to sort:"), page);
  l->addWidget(label);


  fieldList = new KComboBox(false, page);


  fieldList->insertItem("citation key", -1);
  
  
  for (int i = 0; i < BibEntryDefTable::self()->numRefFields(); i++){
	QString fn = BibEntryDefTable::self()->getFieldName(i);
  	fieldList-> insertItem(fn, -1);
  
  }
  
  
  l->addWidget(fieldList);


  groupBox = new QGroupBox("Sorting order", page);
  buttonGroup = new QButtonGroup(groupBox);

  QPixmap image=KGlobal::instance()->iconLoader()->loadIcon( "ascending", KIcon::NoGroup, KIcon::SizeSmall);
  label1 = new QLabel(groupBox);
  label1->setPixmap(image);

  ascending = new QRadioButton(i18n("Ascending"), groupBox);


  image=KGlobal::instance()->iconLoader()->loadIcon( "descending", KIcon::NoGroup, KIcon::SizeSmall);
  label2 = new QLabel(groupBox);
  label2->setPixmap(image);

  descending = new QRadioButton(i18n("Descending"), groupBox);

  ascending->setGeometry(QRect(40,20,130,20));
  descending->setGeometry(QRect(40,50,130,20));
  label1->setGeometry(QRect(20,20,20,20));
  label2->setGeometry(QRect(20,50,20,20));
  buttonGroup->hide();

  buttonGroup->insert(ascending);
  buttonGroup->insert(descending);
  ascending->setChecked(1);
  descending->setChecked(0);

  l->addWidget(groupBox);
  l->insertSpacing(2,8);
  l->addSpacing(10);
  l->addStretch(1);
  groupBox->setMinimumWidth(180);
  groupBox->setMinimumHeight(80);
}


KBibSortDlg::~KBibSortDlg()
{
  delete label;
  delete fieldList;
  delete ascending;
  delete descending;
  delete buttonGroup;
  delete label1;
  delete label2;
  delete groupBox;

}

QString KBibSortDlg::getFieldToSort()
{
  return fieldList->currentText();

}

int KBibSortDlg::sortOrder()
{
  if (ascending->isChecked())
    return 1;
  else
    return 0;
}

#include "kbibsortdlg.moc"
