/***************************************************************************
                          kbibselectentrytype  -  description
                             -------------------
    begin                : Fri Apr 9 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlayout.h>
#include "kbibselectentrytype.h"

#include "bibentrytable.h"
#include <klocale.h>

KbibSelectEntryType::KbibSelectEntryType(QWidget *parent, const char *name)
    :KDialogBase( parent, name , false, 0, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{

  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());
  l->setSpacing(4);

  elabel = new QLabel(i18n("Reference type:"), page);
  l->addWidget(elabel);

  entryList = new KComboBox(false, page);
  
  entryList->insertStringList(BibEntryDefTable::self()->getEntryDefNames());
  
  entryList->setMinimumWidth(150);
  l->addWidget(entryList);
  l->addSpacing(10);
  l->addStretch(1);
}



KbibSelectEntryType::~KbibSelectEntryType()
{
  delete elabel;
  delete entryList;
}

QString KbibSelectEntryType::get_entryType(void)
{
  return entryList->currentText();
}


//#include "kbibselectentrytype.moc"
