//
// C++ Implementation: kbibexporthtmldlg
//
// Description:
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kbibexporthtmldlg.h"

#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <qcolor.h>
#include <qlayout.h>
#include <qhbox.h>

KBibExportHTMLDlg::KBibExportHTMLDlg(QWidget *parent, const char *name)
        :KDialogBase( parent, name , true, 0, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
    QWidget* page = new QWidget(this);
    setMainWidget(page);
    QVBoxLayout* l = new QVBoxLayout(page, 0, KDialog::spacingHint());



    QHBox* box1 = new QHBox(page);
    box1->setMargin(4);
    box1->setSpacing(4);

    new QLabel(i18n("Biliography Style:"), box1);

    bibStyle = new KComboBox(false, box1);
    bibStyle->insertItem("amsalpha", -1);
    bibStyle->insertItem("amsplain", -1);
    bibStyle->insertItem("amsxport", -1);
    bibStyle->insertItem("abbrv", -1);
    bibStyle->insertItem("alpha", -1);
    bibStyle->insertItem("apalike", -1);
    bibStyle->insertItem("ieeetr", -1);
    bibStyle->insertItem("plain", -1);

    bibStyle->setEditable(true);
    bibStyle->setCurrentText("plain");
    browseBttn = new KPushButton("...", box1) ;
    QPixmap pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("fileopen"), KIcon::Small);
    browseBttn->setPixmap(pix);
    browseBttn->setMinimumWidth(40);
    box1->setStretchFactor(bibStyle, 1);
    box1->setStretchFactor(browseBttn, 0);

    l->addWidget(box1);

    includeAbstract =  new QCheckBox(i18n("Include abstract"), page);
    includeAbstract->setChecked(TRUE);

    includeKeywords =  new QCheckBox(i18n("Include keywords"), page);
    includeKeywords->setChecked(FALSE);



    groupBox = new QVGroupBox("Sorting", page);
    groupBox->setMargin(10);
    buttonGroup = new QButtonGroup(groupBox);
    byDate = new QRadioButton(i18n("Sort by date"), groupBox);

    byAuthor = new QRadioButton(i18n("Sort by authors"), groupBox);
    unsort = new QRadioButton(i18n("Do not sort"), groupBox);

    revertOrder = new QCheckBox(i18n("Reverse order"), groupBox );
    buttonGroup->hide();

    buttonGroup->insert(byDate);
    buttonGroup->insert(byAuthor);
    buttonGroup->insert(unsort);
    byDate->setChecked(1);
    byAuthor->setChecked(0);
    unsort->setChecked(0);
    revertOrder->setChecked(0);

    l->addWidget(groupBox);

    openFile = new QCheckBox(i18n("View HTML file when done"), page);
    openFile->setChecked(TRUE);
    l->addWidget(includeAbstract);
    l->addWidget(includeKeywords);

    l->addWidget(openFile);

    //l->setStretchFactor(box1, 0);
    l->addSpacing(10);
    l->addStretch(1);
    connect(browseBttn, SIGNAL(clicked()), this, SLOT(slotBrowseBttn()) );
}


KBibExportHTMLDlg::~KBibExportHTMLDlg()
{
    delete includeAbstract;
    delete includeKeywords;
    delete bibStyle;
    delete browseBttn;
    delete openFile;

    delete byDate;
    delete byAuthor;
    delete unsort;
    delete revertOrder;

    delete buttonGroup;
    delete groupBox;
}

int KBibExportHTMLDlg::getSortBy()
{
    if (byDate->isChecked())
        return 1;
    else if (byAuthor->isChecked())
        return 2;
    else
        return 0;

}

void KBibExportHTMLDlg::slotBrowseBttn()
{
    QString filter = i18n("*.bst|Biliography style files (*.bst)");


    QString fn = KFileDialog::getOpenFileName(QString::fromLatin1(":open"), filter,
                 this, i18n("Open File..."));

    if (!fn.isEmpty())
    {
        bibStyle->setCurrentText(fn);
    }

}

#include "kbibexporthtmldlg.moc"
