//
// C++ Interface: ieeexploresearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef IEEEXPLORESEARCHER_H
#define IEEEXPLORESEARCHER_H


#include <searcher.h>
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>
#include <qcheckbox.h>

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
 */

class KLineEdit;

class IEEEXploreSearcher;



class IEEEXploreConfigWidget : public SearcherConfigWidget
{
	public:
		IEEEXploreConfigWidget(QWidget* parent, IEEEXploreSearcher* searcher = 0);
		virtual void updateSearcher();
	private:
		KLineEdit* m_hostEdit;
		QCheckBox* m_freeSearchSelect;
			
};



class IEEEXploreSearcher : public searcher
{
	Q_OBJECT
	public:
		IEEEXploreSearcher(QObject *parent = 0, const char *name = 0);
		virtual ~IEEEXploreSearcher();

		virtual QString source() const;
		virtual void setSource(const QString );
		virtual QString helpURL() {return QString::fromLatin1("http://ieeexplore.ieee.org/xplorehelp/whnjs.htm")  ; }
		virtual bool isSearching() const { return m_started; }
		virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
		virtual void search(QString query);
		virtual void stop();
		virtual Type type() const { return IEEEXplore; }
		virtual void readConfig(KConfig* config, const QString& group);
		virtual void saveConfig(KConfig* config);
		virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
		friend class IEEEXploreConfigWidget;
		virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
		virtual void retrieveRange(unsigned int min, unsigned int max);
		virtual QStringList searchKey();
		static QString defaultName();
		virtual int	maxSearchTerms();
		void setHost(QString host) { m_host = host; }

	private slots:
		void slotData(KIO::Job* job, const QByteArray& data);
		void slotComplete(KIO::Job* job);

	private:
		void searchResults();
		void fetchResults();

		enum Step {
			Begin,
			Search,
			Wait,
			Fetch
		};

		QString m_host;
		bool m_freeSearch;
		KURL m_url;
		QByteArray m_data;
		int m_total;
		int m_start, m_end;
		QString m_query;
		QGuardedPtr<KIO::Job> m_job;
		Step m_step;
		bool m_started;
};


#endif
