//
// C++ Interface: citebasesearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CITEBASESEARCHER_H
#define CITEBASESEARCHER_H

#include <searcher.h>
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/


class CitebaseSearcher;

class CitebaseConfigWidget : public SearcherConfigWidget
{
	public:
		CitebaseConfigWidget(QWidget* parent, CitebaseSearcher* searcher = 0);
		virtual void updateSearcher() {};
};


class CitebaseSearcher : public searcher
{
Q_OBJECT
public:
	CitebaseSearcher(QObject *parent = 0, const char *name = 0);

    	virtual ~CitebaseSearcher();
	virtual QString source() const;
	virtual void setSource(const QString );
	virtual QString helpURL() { return QString::fromLatin1("http://www.citebase.org"); }
	virtual bool isSearching() const { return m_started; }
	virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
	virtual void search(QString queryString);
	virtual void stop();
	virtual Type type() const { return Citebase; }
	virtual void readConfig(KConfig* config, const QString& group);
	virtual void saveConfig(KConfig* config);
	virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
	friend class CitebaseConfigWidget;
	virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
	virtual void retrieveRange(unsigned int min, unsigned int max);
	virtual QStringList searchKey();
	virtual int maxSearchTerms() {return 1; }
	static QString defaultName();
	
private slots:
	void slotData(KIO::Job* job, const QByteArray& data);
	void slotComplete(KIO::Job* job);

private:
	void searchResults();
	void fetchResults();
	void startRequest(QString url);

	enum Step {
		Begin,
		Query,
		Wait,
		Fetch,
	};

	KURL m_url;
	QByteArray m_data;
	int m_total;
	QString m_query;
	QGuardedPtr<KIO::Job> m_job;
	Step m_step;
	bool m_started;

};

#endif
