/***************************************************************************
                          bibentrytable.h  -  description
                             -------------------
    begin                : Sun May 25 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _BIBENTRYTABLE_H
#define _BIBENTRYTABLE_H


#include <vector>
#include <list>
#include <string>
using namespace std;

#include "bibentry.h"
#include "bibfile.h"

class BibentryTable
{
public:
    BibentryTable();
    ~BibentryTable();

    void clear();
	
	void clearStringMacro() {stringMacros.clear(); }
    void new_entry(BibEntry&);
    void new_entry(BibEntry*);
    void new_stringMacro(QString, QString);
    BibEntry *get_entry(int);
	QMap<QString, QString> getStringMacros() { return stringMacros; }
	QStringList getStringMacroKeys() { QValueList<QString> l = stringMacros.keys(); return QStringList(l ); }
	QStringList getStringMacroValues() { QValueList<QString> l = stringMacros.values(); return QStringList(l ); }
	QPair<QString, QString> getStringMacro(int i);
	QString getStringMacroValue(QString key);
    int readBibfile(char *, bool import = 0);
	void readEntry(FILE *inf, bool import, bool &bib, bool &string, bool ignoreUndefinedType = false, bool ignoredUndefinedField = false, bool notInsertExisting = false );
	QString getPreamble() {return preamble; }
	void setPreamble(QString st) { preamble = st; }
    string dbname;
    int size()
    {
        return entryTab.size();
    }
    int stringMacroSize(){ return stringMacros.count(); }

    int writeBibfile(const char *name, int fieldDelimiter = 0);

    void removeEntryTab();

    void createKeys(const QString = "");

    int searchKey(const QString, int start=0);

    void createKey(int i, const QString connectingString = "");

    int search_string(char *s, int first, int att, int opt);

    void delete_entry(int i);

    void sort(int ascending, QString s = QString::fromLatin1("citation key"));

    int removeDuplicated(int compareSetting=0);

    void updateEntryIndices(void);

    void change_entry(int index, BibEntry *);
	QString getFieldText(BibEntry *bibItem, QString fieldName);
	QString detailedEntry(BibEntry *bibItem);
	QString formatEntry(BibEntry *entry, bool richText=true);

private:
    //static vector<BibEntry *> entryTab;
	vector<BibEntry *> entryTab;
	QMap<QString, QString> stringMacros;
	QString preamble;
};

void print_entry(FILE *fp, BibEntry *e, char ld='{', char rd = '}');

#endif
