//
// C++ Interface: bibentrydeftable
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef BIBENTRYDEFTABLE_H
#define BIBENTRYDEFTABLE_H

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
#include <qstringlist.h>
#include <qdict.h>
#include <qptrlist.h>
#include <iostream>

enum FieldType{TEXT, PARAGRAPH, MULTIPLE, NUMBER, URL, MONTH, KEYWORDS, JOURNALS };

typedef struct RefField
{
	QString name;
	int type;
	QString connectingString;
	bool autoCompletion;
	bool allowGrouping;	
}
RefField;


class BibEntryDef
{
	public:
		BibEntryDef(){}
		//int nreq, nopt;
		int numRequired() { return required.count() ;}
		int numOptional() { return optional.count() ;}
		//string name;
		QString name;
		QStringList required;
		QStringList optional;
		bool readOnly;

		QString getRequired ( int );
		QString getOptional ( int );
		int getFieldIdx(QString);

		~BibEntryDef() {}
};



class BibEntryDefTable{
public:
	static BibEntryDefTable* self() {  if(!s_self)  s_self = new BibEntryDefTable(); return s_self; }
    BibEntryDefTable();
	~BibEntryDefTable();
	void newEntryDef (QString name, QStringList required, QStringList optional, bool readOnly, bool overwrite);
	void newRefField(QString name, 	int type, QString connectingString, bool autoCompletion, bool allowGrouping, bool overwrite);
	bool allowGrouping;	
	void deleteEntryDef(QString name);
	void clear();
	void clearRefFields();
	BibEntryDef *getBibEntryDef(QString name) const { return entryDefs[name] ;}
	RefField* getRefField(QString name) const { return refFields[name.lower()]; }
	
	QString getEntryTypeName ( int);
	
//	QPtrList<RefField> getRefFields() { return refFields; };
//	QDict<BibEntryDef> getEntryDefs() { return entryDefs; }
	QStringList getEntryDefNames() { return entryDefTab; }
	QStringList getFieldNames() { return fieldNameTab; }
	
	QString getFieldName(int);
	
	
	int numEntryDefs(void) { return entryDefs.count(); }
	int numRefFields(void) { return refFields.count(); }
	void readEntryDefFile(QString filename);
	void writeEntryDefFile(QString filename);
	
	private:
		static BibEntryDefTable* s_self;
		QDict<BibEntryDef>  entryDefs;
		QDict<RefField> refFields;
		QStringList entryDefTab;
		QStringList fieldNameTab;
};

#endif
