//
// C++ Implementation: paragraphfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "paragraphfieldwidget.h"

#include <qcheckbox.h>
#include <kpushbutton.h>
#include <kdialog.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qtooltip.h>


namespace GUI {

ParagraphFieldWidget::ParagraphFieldWidget(QString _name, RefField* field,  QStringList macroKeys, QWidget *parent, const char *name)
 : FieldWidget(parent, name)
{
	m_field = field;
	m_name = _name;
	QHBoxLayout* l = new QHBoxLayout(this, 0, KDialog::spacingHint());
	QString fn = m_name;
	QChar c = fn.at(0); 
	fn = fn.replace(0, 1, c.upper());
	
	m_label = new QLabel(fn+QString::fromLatin1(":"), this);
	m_textEdit = new FieldTextEdit(this);
	m_label->setBuddy(m_textEdit);
	QString msg = i18n("Enter the value of the %1 field here. %2 is a paragraph text field").arg(m_name.lower()).arg(fn);
	QWhatsThis::add ( m_textEdit,  msg);
	QToolTip::add ( m_textEdit,  msg);
	
	m_stringMacroIndicator = new QCheckBox(i18n("As String Macro"), this);
	msg = i18n("When checked, the value of the %1 field is a string macro key.").arg(m_name.lower());
	QWhatsThis::add ( m_stringMacroIndicator, msg );
	QToolTip::add ( m_stringMacroIndicator, msg );
	
	m_stringMacroSelect = new KPushButton(i18n("Macros"), this);	
	msg = i18n("Set the %1 field to use one of the defined string macro keys.").arg(m_name.lower());
	QWhatsThis::add ( m_stringMacroSelect, msg );
	QToolTip::add ( m_stringMacroSelect, msg );
	m_stringMacroSelect->setFixedHeight(m_stringMacroSelect->sizeHint().height());
	l->addWidget(m_label);
	l->addWidget(m_textEdit);
	l->addWidget(m_stringMacroIndicator);
	l->addWidget(m_stringMacroSelect);
	
	m_stringMacroMenu = new KPopupMenu(this);
	m_stringMacroSelect->setPopup(m_stringMacroMenu);
	
	for ( QStringList::Iterator it = macroKeys.begin(); it != macroKeys.end(); ++it ) {
        m_stringMacroMenu->insertItem(*it);
    }
	
	if (m_stringMacroMenu->count () > 0)
		 m_stringMacroSelect->show();
	else
		m_stringMacroSelect->hide();
	
	connect(m_stringMacroMenu, SIGNAL(activated(int)),
			this, SLOT(slotMacroMenuActivated(int)));
	
}


ParagraphFieldWidget::~ParagraphFieldWidget()
{
}

void ParagraphFieldWidget::setText(QString st)
{
	m_textEdit->setText(st);	
	m_textEdit->setCursorPosition(0, 0);
	
}


QString ParagraphFieldWidget::getText(void){
	return (m_textEdit->text());
}

void ParagraphFieldWidget::slotMacroMenuActivated(int id){
	m_textEdit->setText(m_stringMacroMenu->text(id));
	m_stringMacroIndicator->setChecked(true);	
	m_textEdit->setFocus();
}

void ParagraphFieldWidget::setAutoCompletion(QStringList list){
}

}
#include "paragraphfieldwidget.moc"
