/***************************************************************************
                          kbiblistview.h  -  description
                             -------------------
    begin                : Mon May 26 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBLISTVIEW_H
#define KBIBLISTVIEW_H

#include <vector>
#include <list>
using namespace std;

#include <qlistview.h>
#include <qptrlist.h>
#include <kpopupmenu.h>
#include <qtextview.h>
#include <qstring.h>

#include <klistview.h>
#include <kpopupmenu.h>
#include <kurl.h>

#include <qpoint.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qvaluevector.h>
#include <qguardedptr.h>
#include <qobject.h>
#include <qdragobject.h>

#include "bibentrytable.h"
#include "bibentry.h"
//#include "entrydef.h"

#include "kbiblistviewitem.h"
#include "kbibeditentrydlg.h"
#include "kbibpreview.h"

/**
  *@author Thach Nguyen
  */

class KBibListView : public KListView
{
        Q_OBJECT

public:
        KBibListView(QWidget *parent, const char* name=0);
        ~KBibListView();
        void updateListView(BibentryTable * list);
        void updateCurrentListView(void);

        void addPreview(KBibPreview *preview);

        //BibEntry* editEntry(BibEntry * entry);
        /** No descriptions */
        BibEntry * getItemBibEntry(unsigned int index);
        unsigned int getListSize(void);
        //QString citeSelected();
        void clearListView();
        void highlightItem(unsigned int i);
        void saveSelected(KURL url);

        void addNewItem(BibEntry *);

        vector<int> *getSelected(void);
        vector<int> *deleteSelected(void);
        void viewSelected(void);
        void hideSelected(void);
        int showDuplicated();
        void showByRefType(QString);
        QString getSelectedText();
        void invertSelection();
        void updateColumn();
		void deleteEntry(int index);

public slots:
        void slotHandleDelete();

        void slotRMB(QListViewItem* item_, const QPoint& point_, int col) ;
        /** No descriptions */
        void itemSelected(QListViewItem *);
        void itemDoubleClicked(QListViewItem *);
        /** No descriptions */
        void slotNewItem();
        /** No descriptions */
        void slotCiteEntry();
        /** No descriptions */
        void slotViewURL();
		void slotViewFile();
        /** No descriptions */
        void slotEditEntry();
        void slotCopy();
        void slotPaste();
        void slotCut();
        void slotLockKey();
        void slotUnlockKey();
        void slotSelectionChanged();
        void slotDropped(QDropEvent* event);
        void slotDropCopy();
        void slotDropCancel();

protected:
        //void dragEnterEvent(QDragEnterEvent* event);
        //void dropEvent(QDropEvent* event);
        bool acceptDrag (QDropEvent* event) const;
        void startDrag();
        static QPtrList<KBibListViewItem> *list_view;
private:
        KPopupMenu* m_itemMenu;
        KPopupMenu* dropMenu;
        //  QTextView * p_preview;
        KBibPreview * p_preview;
        QString droppedText;


signals: // Signals
        /** No descriptions */
        void signalListChange();
};

#endif
