/***************************************************************************
                          kbibdoc.h  -  description
                             -------------------
    begin                : Sat May 24 16:37:30 EST 2003
    copyright            : (C) 2003 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIBDOC_H
#define KBIBDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>

// include files for KDE
#include <kurl.h>

#include "kbiblistview.h"
#include "kbibgroupview.h"
#include "bibentrytable.h"

// forward declaration of the KBib classes

/**	KBibDoc provides a document object for a document-view model.
  *
  * The KBibDoc class provides a document object that can be used in conjunction with the classes KBibApp and KBibView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KBibApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KBibView objects. Also, KBibDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KBibDoc : public QObject
{
    Q_OBJECT
public:
    /** Constructor for the fileclass of the application */
    KBibDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KBibDoc();


    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true)
    {
        modified=_m;
    };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified()
    {
        return modified;
    };
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();

    void addListView(KBibListView *view);
	void addGroupView(KBibGroupView *view);

    bool openDocument(const KURL url_, bool import = false);


    void setURL(const KURL& url) {m_url = url;}
    const KURL& getURL() const {return m_url; }


    bool saveDocument(const KURL& url_);

    int size(void);

    void createKeys(const QString connectingString="");

    int searchKey(const QString st, int start=0);

    void sort(int ascending, QString st);

    BibEntry* getEntry(int i);

    BibentryTable * getEntryList(void);

    int search_string(char *, int first, int att, int opt);


    int removeDuplicated(void);

    int deleteEntry(int i);

    int deleteEntry(vector<int> *i);

    void paste(QString str);
    bool newEntry();
	void addEntry(BibEntry*, bool ignoreExisting = false, bool fixDuplicatedKey=false);
    BibEntry*  editEntry(BibEntry * xentry);
    bool modifyEntry(int index);

    int importBibTexFile(const QString fn, bool import, bool notInsertExisting);
	
	QStringList getValueList(QString fn);
	

public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
private:
    KBibListView *p_view;
	KBibGroupView *group_view;

	
    /** the modified flag of the current document */
    bool modified;
    KURL	m_url;
    BibentryTable * entry_list;



};

#endif // KBIBDOC_H
