/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MODULE_H__
#define __KZ_MODULE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_MODULE            (kz_module_get_type ())
#define KZ_MODULE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_MODULE, KzModule))
#define KZ_MODULE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_MODULE, KzModuleClass))
#define KZ_IS_MODULE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_MODULE))
#define KZ_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_MODULE))
#define KZ_MODULE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_MODULE, KzModuleClass))

typedef struct _KzModule KzModule;
typedef struct _KzModuleClass KzModuleClass;

struct _KzModule
{
    GTypeModule object;
};

struct _KzModuleClass
{
    GTypeModuleClass parent_class;
};

GType     kz_module_get_type		(void) G_GNUC_CONST;


KzModule *kz_module_load_module		(const gchar	*base_dir,
					 const gchar	*name);
GList    *kz_module_load_modules	(const gchar    *base_dir);
GList    *kz_module_load_modules_unique	(const gchar    *base_dir,
					 GList		*modules);

KzModule *kz_module_find		(GList          *modules,
					 const gchar    *name);

GObject  *kz_module_instantiate		(KzModule	*module,
					 const gchar	*first_property,
					 va_list	 var_args);
const gchar *kz_module_get_name		(KzModule	*module);

void      kz_module_exit		(KzModule	*module);
void      kz_module_unload		(KzModule	*module);

G_END_DECLS

#endif /* __KZ_MODULE_H__ */
