#include "glglue.h"

#include <KayaAPI.h>
#include <VMState.h>
#include <GL/glut.h>
#include <GL/glu.h>
#include <GL/gl.h>

#define UTAG(x) switch(KayaUnionGetTag(x))
#define UARG KayaUnionGetArg

// Yuck
/*bool getglBool(GLboolean b) {
    return (b==GL_TRUE);
    }*/

int glGetMatrixMode(KayaValue k)
{
    UTAG(k) {
    case 0: return GL_PROJECTION;
    case 1: return GL_MODELVIEW;
    case 2: return GL_TEXTURE;
    }
}

int glGetShadeModel(KayaValue k) {
    UTAG(k) {
    case 0: return GL_FLAT;
    case 1: return GL_SMOOTH;
    }
}

int glGetBuffer(KayaValue k) {
    UTAG(k) {
    case 0: return GL_COLOR_BUFFER_BIT;
    case 1: return GL_DEPTH_BUFFER_BIT;
    case 2: return GL_ACCUM_BUFFER_BIT;
    case 3: return GL_STENCIL_BUFFER_BIT;
    }
}

int maskBuffers(KayaArray ks) {
    return orArray(ks,glGetBuffer);
}

int glGetPrimitive(KayaValue k) {
    UTAG(k) {
    case 0: return GL_POINTS;
    case 1: return GL_LINES;
    case 2: return GL_LINE_STRIP;
    case 3: return GL_LINE_LOOP;
    case 4: return GL_TRIANGLES;
    case 5: return GL_TRIANGLE_STRIP;
    case 6: return GL_TRIANGLE_FAN;
    case 7: return GL_QUADS;
    case 8: return GL_QUAD_STRIP;
    case 9: return GL_POLYGON;
    }
}

int glGetFeature(KayaValue k) {
    int x;
    UTAG(k) {
    case 0: return GL_DEPTH_TEST;
    case 1: return GL_BLEND;
    case 2: return GL_FOG;
    case 3: return GL_LINE_STIPPLE;
    case 4: return GL_LIGHTING;
    case 5: x = KayaGetInt(KayaUnionGetArg(k,0));
	switch(x) {
	case 0: return GL_LIGHT0;
	case 1: return GL_LIGHT1;
	case 2: return GL_LIGHT2;
	case 3: return GL_LIGHT3;
	case 4: return GL_LIGHT4;
	case 5: return GL_LIGHT5;
	case 6: return GL_LIGHT6;
	case 7: return GL_LIGHT7;
	}
    case 6: return GL_NORMALIZE;
    case 7: return GL_COLOR_MATERIAL;
    case 8: return GL_POINT_SMOOTH;
    case 9: return GL_LINE_SMOOTH;
    case 10: return GL_CULL_FACE;
    case 11: return GL_TEXTURE_1D;
    case 12: return GL_TEXTURE_2D;
    case 13: return GL_SCISSOR_TEST;
    case 14: return GL_ALPHA_TEST;
    case 15: return GL_STENCIL_TEST;
    case 16: return GL_AUTO_NORMAL;
    }
}

bool doGLIsEnabled(int f)
{
    return (glIsEnabled(f)==GL_TRUE);
}

int glGetListMode(KayaValue k) {
    UTAG(k) {
    case 0: return GL_COMPILE;
    case 1: return GL_COMPILE_AND_EXECUTE;
    }
}

int glGetFace(KayaValue k) {
    UTAG(k) {
    case 0: return GL_FRONT;
    case 1: return GL_BACK;
    case 2: return GL_FRONT_AND_BACK;
    }
}

int glGetMaterialMode(KayaValue k) {
    UTAG(k) {
    case 0: return GL_AMBIENT;
    case 1: return GL_DIFFUSE;
    case 2: return GL_AMBIENT_AND_DIFFUSE;
    case 3: return GL_SPECULAR;
    case 4: return GL_EMISSION;
    }
}

int glGetTexFunc(KayaValue k) {
    UTAG(k) {
    case 0: return GL_DECAL;
    case 1: return GL_REPLACE;
    case 2: return GL_MODULATE;
    case 3: return GL_BLEND;
    }
}


int glGetPixelFormat(KayaValue k) {
    UTAG(k) {
    case 0: return GL_RGBA;
    case 1: return GL_RED;
    case 2: return GL_GREEN;
    case 3: return GL_BLUE;
    case 4: return GL_ALPHA;
    case 5: return GL_LUMINANCE;
    case 6: return GL_LUMINANCE_ALPHA;
    case 7: return GL_DEPTH_COMPONENT;
    }
}

int glGetType(KayaValue k) {
    UTAG(k) {
    case 0: return GL_UNSIGNED_BYTE;
    case 1: return GL_BYTE;
    case 2: return GL_BITMAP;
    case 3: return GL_UNSIGNED_SHORT;
    case 4: return GL_SHORT;
    case 5: return GL_UNSIGNED_INT;
    case 6: return GL_INT;
    case 7: return GL_FLOAT;
    }
}

int glGetTexTarget(KayaValue k, int dim)
{
    if (dim==2) {
	UTAG(k) {
	case 0: return GL_TEXTURE_2D;
	case 1: return GL_PROXY_TEXTURE_2D;
	}
    }
    else {
	UTAG(k) {
	case 0: return GL_TEXTURE_1D;
	case 1: return GL_PROXY_TEXTURE_1D;
	}
    }
}

int glGetTexType(KayaValue k)
{
    UTAG(k) {
    case 0: return GL_TEXTURE_1D;
    case 1: return GL_TEXTURE_2D;
    }
}

int glGetTexWrap(KayaValue k)
{
    UTAG(k) {
    case 0: return GL_CLAMP;
    case 1: return GL_REPEAT;
    }
}

int glGetTexFilter(KayaValue k)
{
    UTAG(k) {
    case 0: return GL_NEAREST;
    case 1: return GL_LINEAR;
    case 2: return GL_NEAREST_MIPMAP_NEAREST;
    case 3: return GL_NEAREST_MIPMAP_LINEAR;
    case 4: return GL_LINEAR_MIPMAP_NEAREST;
    case 5: return GL_LINEAR_MIPMAP_LINEAR;
    }
}

#define COPYARR(a,v) \
a[0] = (float)KayaGetFloat(KayaUnionGetArg(v,0)); \
a[1] = (float)KayaGetFloat(KayaUnionGetArg(v,1)); \
a[2] = (float)KayaGetFloat(KayaUnionGetArg(v,2)); \
a[3] = (float)KayaGetFloat(KayaUnionGetArg(v,3));

#define COPYARR3(a,v) \
a[0] = (float)KayaGetFloat(KayaUnionGetArg(v,0)); \
a[1] = (float)KayaGetFloat(KayaUnionGetArg(v,1)); \
a[2] = (float)KayaGetFloat(KayaUnionGetArg(v,2));

#define FARG(x,i) ((float)KayaGetFloat(KayaUnionGetArg(x,i)))

void doglLight(int l, KayaValue p)
{
    GLfloat arr[] = { 0.0, 0.0, 0.0, 0.0 };
    UTAG(p) {
    case 0: COPYARR(arr,p);
	glLightfv(l,GL_AMBIENT,arr);
	break;
    case 1: COPYARR(arr,p);
	glLightfv(l,GL_DIFFUSE,arr);
	break;
    case 2: COPYARR(arr,p);
	glLightfv(l,GL_SPECULAR,arr);
	break;
    case 3: COPYARR(arr,p);
	glLightfv(l,GL_POSITION,arr);
	break;
    case 4: COPYARR3(arr,p);
	glLightfv(l,GL_SPOT_DIRECTION,arr);
	break;
    case 5: glLightf(l,GL_SPOT_EXPONENT,FARG(p,0)); break;
    case 6: glLightf(l,GL_SPOT_CUTOFF,FARG(p,0)); break;
    case 7: glLightf(l,GL_CONSTANT_ATTENUATION,FARG(p,0)); break;
    case 8: glLightf(l,GL_LINEAR_ATTENUATION,FARG(p,0)); break;
    case 9: glLightf(l,GL_QUADRATIC_ATTENUATION,FARG(p,0)); break;
    }
}

void doglMaterial(int l, KayaValue p)
{
    GLfloat arr[] = { 0.0, 0.0, 0.0, 0.0 };
    UTAG(p) {
    case 0: COPYARR(arr,p);
	glMaterialfv(l,GL_AMBIENT,arr);
	break;
    case 1: COPYARR(arr,p);
	glMaterialfv(l,GL_DIFFUSE,arr);
	break;
    case 2: COPYARR(arr,p);
	glMaterialfv(l,GL_AMBIENT_AND_DIFFUSE,arr);
	break;
    case 3: COPYARR(arr,p);
	glLightfv(l,GL_SPECULAR,arr);
	break;
    case 4: glMaterialf(l,GL_SHININESS,FARG(p,0)); break;
    case 5: COPYARR(arr,p);
	glMaterialfv(l,GL_EMISSION,arr);
	break;
    }
}


void doglTexParam(int target, KayaValue p)
{
    GLfloat arr[] = { 0.0, 0.0, 0.0, 0.0 };
    UTAG(p) {
    case 0: 
	glTexParameterf(target, GL_TEXTURE_WRAP_S, glGetTexWrap(UARG(p,0)));
	break;
    case 1: 
	glTexParameterf(target, GL_TEXTURE_WRAP_T, glGetTexWrap(UARG(p,0)));
	break;
    case 2: 
	glTexParameterf(target, GL_TEXTURE_MAG_FILTER, glGetTexFilter(UARG(p,0)));
	break;
    case 3: 
	glTexParameterf(target, GL_TEXTURE_MIN_FILTER, glGetTexFilter(UARG(p,0)));
	break;
    case 4: COPYARR(arr,p);
	glTexParameterfv(target,GL_TEXTURE_BORDER_COLOR, arr);
	break;
    case 5: 
	glTexParameterf(target, GL_TEXTURE_PRIORITY, FARG(p,0));
	break;
    }
}

int doGenTexture()
{
    GLuint t;
    glGenTextures(1,&t);
    return t;
}

int doDeleteTexture(GLuint t)
{
    glDeleteTextures(1,&t);
}

void glTexMode(int f)
{
    glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,f);
}

bool checkError(void *vmptr, KayaValue errmsg)
{
    VMState* vm = (VMState*)vmptr;
    GLenum err = glGetError();
    if (err!=GL_NO_ERROR) {
//	printf("%s\n",gluErrorString(err));
	KayaSetString(errmsg, KSTRING((char*)(gluErrorString(err))));
	return false;
    }
    return true;
}
