/*
 * sourcemanager.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SOURCEMANAGER_HH__
#define __SOURCEMANAGER_HH__

#include <map>
#include <vector>
#include <string>
#include <gtksourceview/gtksourcelanguagesmanager.h>
#include <gtksourceview/gtksourcelanguage.h>

typedef std::map<std::string, std::vector<int> > SourceCategory;
typedef SourceCategory::iterator SourceCategoryIter;

class SourceLanguage {
public:
  SourceLanguage(GtkSourceLanguage *&);
  ~SourceLanguage();
  std::string get_name();
  GtkSourceLanguage* gobj();

private:
  // We are dealing with pointers.
  SourceLanguage(SourceLanguage&);
  SourceLanguage& operator=(const SourceLanguage&);

  GtkSourceLanguage *_lang;
  char *name;
};

class SourceManager {
public:
  SourceManager();
  ~SourceManager();
  SourceCategory& get_categories();
  std::string get_name(unsigned);
  int get_language(const std::string&);
  SourceLanguage*& get_language(int);
  //SourceLanguage& get_language(const std::string&);
  void set_map(int, int);
  int get_map(int);
private:
  GtkSourceLanguagesManager *manager;
  SourceCategory cats;
  std::vector<SourceLanguage *> _languages;
  //  std::map<std::string, int> mimedb;
  std::map<int, int> link;
};

#endif /* __SOURCEMANAGER_HH__ */
