/***************************************************************************
 *   Copyright (C) 2005 by Laurent Montel <montel@kde.org>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/


#ifndef _KATPROCESSMANAGER_H_
#define _KATPROCESSMANAGER_H_

#include <qobject.h>
#include <kprocess.h>
#include <qstring.h>

#include "../kio_fulltext/fulltextextractorbase.h"

class KatProcessManager : public QObject
{
Q_OBJECT

public:
    KatProcessManager();
    ~KatProcessManager();

    QString buffer() const { return m_buffer; };

public slots:
    void slotProcessExited( KProcess* );
    void slotReceivedStdout( KProcess*, char*, int );

private:
    QString m_buffer;
};

class KatExternalExtractor : public FulltextExtractor
{
public:
    KatExternalExtractor( const QString& path, bool htmlOutput );
    virtual ~KatExternalExtractor();
    virtual void extract( QString &data );
    virtual void helperParameter( const QString &)=0;
    virtual QString helper() const = 0;
private:
    bool m_bDone;
    bool m_bHtmlOutput;
protected:
    QString m_path;
    KProcess* proc;
    KatProcessManager *kpm;
};


#endif
