/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATWATCHER_H_
#define _KATWATCHER_H_

#include <qobject.h>
#include <qstring.h>

#include "kat_export.h"

class KAT_EXPORT KatWatcher : public QObject
{
Q_OBJECT

public:
    enum EventType {
        Access,
        Modify,
        Attrib,
        Close,
        Open,
        Move,
        Create,
        Delete,
        DeleteSelf,
        Unmount
    };

    KatWatcher( QObject* obj, const char* name ) : QObject( obj, name ) {};

    virtual int watch ( QString, EventType ) { return ( -1 ); } ;
    virtual void stopWatcher() {};
    virtual bool enabled() { return false; };
    virtual void startWatcher() {};
    virtual int watchCount() { return 0; };
    virtual bool running() { return false;};

    /* fpath must be an absolute path */
    virtual bool IsWatching ( const QString & ) { return false; };

signals:
    void onEvent ( KatWatcher::EventType, QString, QString );
};

#endif // _KATWATCHER_H_
