/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Laurent Montel : montel@kde.org                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATCONTROL_H_
#define _KATCONTROL_H_

#include <kcmodule.h>
#include <kaboutdata.h>
#include <qvariant.h>
#include <qdialog.h>
#include <qwidget.h>
#include "katcatalog.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QListBox;
class QListBoxItem;
class QTabWidget;
class QWidget;
class QPushButton;
class KJanusWidget;
class QVBox;
class KIntNumInput;
class KEditListBox;
class KConfig;
class KatEngine;
class KatCatalog;
class QListBox;
class QPushButton;
class QCheckBox;

class katRegexpWidget : public QWidget
{
Q_OBJECT
public:
    katRegexpWidget( QWidget* parent, char* name = 0 );
    ~katRegexpWidget();
    void setPattern( const QString &);
    QString pattern() const;
    KLineEdit *lineEdit() const { return m_editLinePattern;}
public slots:
    void slotEditPattern();

protected:
    void init();
private:
    bool m_regexpDialogQueryDone;
    QPushButton *m_editPattern;
    KLineEdit *m_editLinePattern;
    QDialog* m_regexpDialog;
};

class catalogPage : public QWidget
{
Q_OBJECT

public:
    catalogPage( QWidget* parent, char* name = 0 );
    ~catalogPage();

    void load();
    void save();
    void defaults();

protected slots:
    void slotAddCatalog();
    void slotDeleteCatalog();
    void slotUpdateButton();
signals:
    void configChanged();

private:
    
    void deleteCatalogId( int catalogId );
    void addCatalogId( int catalogId );

    QListBox* m_catalogList;
    QPushButton* m_addCatalog;
    QPushButton* m_deleteCatalog;
    KatEngine* m_ke;
    QPtrList<KatCatalog> m_catalogs;
};

class languagePage : public QWidget
{
Q_OBJECT

public:
    languagePage( QWidget* parent, char* name = 0 );
    void load();
    void save();
    void defaults();

signals:
    void configChanged();
};

class advancedPage : public QWidget
{
Q_OBJECT

public:
    advancedPage( QWidget* parent, char* name = 0 );
    void load( KConfig* );
    void save( KConfig* );
    void defaults();

signals:
    void configChanged();

private:
    KIntNumInput* m_schedulerLoad;
    KIntNumInput* m_schedulerWaitBeforeNextJob;
#if 0
    KIntNumInput* m_schedulerNbFileIndexed;
#endif
    KEditListBox* m_excludeFolders;
    KEditListBox* m_excludeFiles;
};

class miscPage : public QWidget
{
Q_OBJECT

public:
    miscPage( QWidget* parent, char* name = 0 );
    void load( KConfig* );
    void save( KConfig* );
    void defaults();

signals:
    void configChanged();

private:
    QCheckBox *m_showSplashScreen;
};

class katcontrol: public KCModule
{
Q_OBJECT

public:
    katcontrol( QWidget* parent = 0, const char* name = 0, const QStringList& = QStringList() );
    ~katcontrol();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData* aboutData() const { return myAboutData; };

public slots:
    void configChanged();

private:
      KAboutData* myAboutData;
      KJanusWidget* m_page;
      languagePage* m_languagePage;
      catalogPage* m_catalogPage;
      advancedPage* m_advancedPage;
    miscPage *m_miscPage;
      KConfig* katConf;
};

#endif // _KATCONTROL_H_

