/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _DLGCREATECATALOG_H
#define _DLGCREATECATALOG_H

#include <kdialogbase.h>

#include "dlgmainwindow.h"

class QTabWidget;
class QWidget;
class QLabel;
class KProgress;
class QButtonGroup;
class QPushButton;
class KTextEdit;
class QTime;
class DlgMainWindow;

class KatEngine;
class KatCatalog;
class KatScanFolder;
class KatInfoExtractor;


class DlgCreateCatalog : public KDialogBase {
Q_OBJECT

public:
    DlgCreateCatalog( DlgMainWindow* parent, const char* name = 0, bool modal = false );
    ~DlgCreateCatalog();

public slots:
    void slotStartScan();
    void slotUpdateScanDialog();
    void slotUpdateExtractDialog();

signals:
    void aborted();

private slots:
    virtual void scanCompleted();
    virtual void extractionCompleted();
    virtual void slotCancel();

private:
    DlgMainWindow* mf;
    KatEngine* m_ke;
    KatCatalog* m_cat;

    QTime m_start;
    QTimer* updateTimer;
    KatScanFolder* m_ksf;
    KatInfoExtractor* m_kie;

    QTabWidget* tabWidget;
    QLabel* tlMessage;
    QLabel* tlScanningFileLabel;
    QLabel* tlScanningFile;
    QLabel* tlScanningFolderLabel;
    QLabel* tlScanningFolder;
    KProgress* pProgress;
    QLabel* tlTimeFromStart;
    QButtonGroup* bgStats;
    QLabel* tlFiles;
    QLabel* tlFoldersNum;
    QLabel* tlArchives;
    QLabel* tlArchivesNum;
    QLabel* tlFileSize;
    QLabel* tlFileSizeNum;
    QLabel* tlWordsNum;
    QLabel* tlFolders;
    QLabel* tlWords;
    QLabel* tlFilesNum;
    QLabel* tlMetaData;
    QLabel* tlMetaDataNum;
    QLabel* tlFullTexts;
    QLabel* tlFullTextsNum;
    QLabel* tlThumbnails;
    QLabel* tlThumbnailsNum;
    QLabel* pixmapLabel1;
    KTextEdit* teDetails;
};

#endif // _DLGCREATECATALOG_H_
