/***************************************************************************
                          cled.cpp  -  description
                             -------------------
    begin                : Sun Jun 18 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cled.h"

CLed::CLed( QWidget *parent, const char *name)
  : KLed( parent, name)
{
  connect(&tempo, SIGNAL(timeout()), SLOT(slotTimeOut()));
}

CLed::CLed(const QColor& ledcolor, QWidget *parent, const char *name)
  : KLed( ledcolor, parent, name)
{
  connect(&tempo, SIGNAL(timeout()), SLOT(slotTimeOut()));
}

CLed::CLed(const QColor& ledcolor, KLed::State state, KLed::Look look, KLed::Shape shape, QWidget *parent, const char *name )
  : KLed( ledcolor, state, look, shape, parent, name)
{
	connect(&tempo, SIGNAL(timeout()), SLOT(slotTimeOut()));
}

CLed::~CLed(){
}

/** After x seconds, the led will fall back to green */
void CLed::slotTimeOut(){
	setColor(QColor("green"));
}

/** set the led color to color */
void CLed::setColor(const QColor& color){
  if(color == QColor("orange"))
  	tempo.start(3500);
  KLed::setColor(color);
}

#include "cled.moc"
