/***************************************************************************
                          cfiledialog.h  -  description
                             -------------------
    begin                : mer sep 24 2003
    copyright            : (C) 2003 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILEDIALOG_H
#define CFILEDIALOG_H

#include <kfiledialog.h>

/**A child class that adds selected file the right extension according to the choosen filter
  *@author Eric Coquelle
  */

class CFileDialog : public KFileDialog  {
  Q_OBJECT
public:
  CFileDialog(const QString& startDir, const QString& filter, QWidget *parent, const char *name, bool modal, QWidget* widget);
  CFileDialog(const QString& startDir, const QString& filter, QWidget *parent, const char *name, bool modal);
  ~CFileDialog();
  /* If selected file doesn't have an extension, add one according to the selected filter*/
  QString fixFileExtension(QString&);
  QString getSaveFileName( const QString & startDir = QString::null, const QString & filter = QString::null, QWidget * parent = 0, const QString & caption = QString::null );

  
protected:
  void init();
  QString filterlist();

protected slots:
  void slotDialogNewArchiveFileSelected(const QString& );
};

#endif
