/***************************************************************************
                          cextraction.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 4 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@hivaoa.unice.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cextraction.h"

#include <qlayout.h>
#include <qgrid.h>
#include <kiconloader.h>
#include <kurlcompletion.h>

int CExtraction::optionextract=1;
QString CExtraction::m_defaultExtractPath=QDir::homeDirPath();
QString CExtraction::path="";

CExtraction::CExtraction(QDialog *parent, const char *name ) : QDialog(parent,name,TRUE) {
	
	KIconLoader icone;
	setIcon(icone.loadIcon("karchiver",KIcon::Small));
        setCaption(i18n("Extract:"));

  QGridLayout *grid1 = new QGridLayout(this,6,5,15,7);
  QButtonGroup* qtarch_ButtonGroup_1;
  qtarch_ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
  qtarch_ButtonGroup_1->setTitle( i18n("Extract:") );
  qtarch_ButtonGroup_1->setExclusive( FALSE );
  grid1->addMultiCellWidget(qtarch_ButtonGroup_1,1,2,2,2);

  listView = new QListView( this, "ListView_directories" );
  grid1->addMultiCellWidget(listView,0,5,0,1);
  listView->addColumn( i18n("Where to extract:"), -1 );
  listView->setMinimumWidth(170);

  directory=new Directory(listView);
  directory->setOpen(TRUE);
  connect(listView, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(retrieve(QListViewItem*)));

  QLabel* qtarch_Label_1;
  qtarch_Label_1 = new QLabel( this, "Label_1" );
  qtarch_Label_1->setText( i18n("Extract To:") );
  grid1->addWidget(qtarch_Label_1,0,2, Qt::AlignRight);


  cbExtractDirectory= new KHistoryCombo( true, this, "combo_extract" );
  grid1->addMultiCellWidget(cbExtractDirectory,0,0,3,4);
  cbExtractDirectory->setInsertionPolicy(QComboBox::AtTop);
  cbExtractDirectory->setEditable(true);
  if(path.isEmpty()||(optionextract!=0))
    cbExtractDirectory->setCurrentItem(m_defaultExtractPath);
  else
    cbExtractDirectory->setCurrentItem(path);
  //Basic completion feature
  KURLCompletion *comp = new KURLCompletion();
  comp->setReplaceHome( true );
  comp->setCompletionMode( KGlobalSettings::CompletionAuto );  
  cbExtractDirectory->setCompletionObject( comp );
  cbExtractDirectory->setMaxCount( 20 );
  cbExtractDirectory->setInsertionPolicy( QComboBox::AtTop );
  cbExtractDirectory->setMinimumWidth(150);
  connect(cbExtractDirectory, SIGNAL(returnPressed(const QString&)), comp, SLOT(addItem(const QString&)));

  QGridLayout *grid2 = new QGridLayout( qtarch_ButtonGroup_1,1,1,15,7);
  qtarch_RadioButton_1 = new QRadioButton( qtarch_ButtonGroup_1, "RadioButton_1" );
  qtarch_RadioButton_1->setText( i18n("All files") );
  qtarch_RadioButton_1->setChecked( TRUE );
  grid2->addWidget(qtarch_RadioButton_1,0,0);
  
  qtarch_RadioButton_2 = new QRadioButton( qtarch_ButtonGroup_1, "RadioButton_2" );
  qtarch_RadioButton_2->setText( i18n("Selected files") );
  qtarch_RadioButton_2->setChecked( FALSE );
  grid2->addWidget(qtarch_RadioButton_2,1,0);
 
  
  qtarch_cbregexp = new QCheckBox( this, "cb_regexp" );
  qtarch_cbregexp->setFocusPolicy( QWidget::TabFocus );
  qtarch_cbregexp->setText( i18n("Use a regular expression") );
  qtarch_cbregexp->setChecked( FALSE );
  grid1->addWidget(qtarch_cbregexp,3,2);
  
  le_regexp=new QLineEdit(this, "reg_exp_lineedit");
  le_regexp->setEnabled(false);
  grid1->addWidget(le_regexp,3,3);
  connect(qtarch_cbregexp, SIGNAL(toggled(bool)), le_regexp, SLOT(setEnabled(bool)));
  
  chLaunchKonqueror = new QCheckBox( i18n("View extracted files in Konqueror"), this, "chkbox_lauchkonqueror");
  chLaunchKonqueror->setChecked(false);
  grid1->addMultiCellWidget(chLaunchKonqueror, 4,4,2,3 );

  bextract=new QPushButton(i18n("Extract"), this, "button_extraction");
  grid1->addWidget(bextract,5,2);
  connect(bextract, SIGNAL(clicked()), SLOT(doExtract()));	

  QPushButton *bcancel;	
  bcancel=new QPushButton(i18n("Cancel"), this, "cancel_button");
  grid1->addWidget(bcancel,5,3);
  connect(bcancel, SIGNAL(clicked()), SLOT(dontExtract()));

  //resize( 490,310 );
  
  history = new CHistory();
  
  setHistory();
}

CExtraction::~CExtraction(){
  writeHistory();
}

void CExtraction::doExtract()
{
	path=cbExtractDirectory->currentText();
	if(path.isEmpty())
		reject();
		
	history->addElement(path);
	writeHistory();
	cbExtractDirectory->clear();
	cbExtractDirectory->insertStrList(history->getElements());
	accept();	
}

void CExtraction::retrieve(QListViewItem *l)
{
	if(l->depth()!=0)
	{
		path="/"+path;
		path=l->text(0)+path;
		retrieve(l->parent());
	}
	else
	{
		path="/"+path;
		cbExtractDirectory->setEditText( path );
		path="";
	}
}

/** Returns the last extract path */
QString & CExtraction::getLastExtractPath()
{
  return path;
}

/* View the extracted directory in Konqueror after extracting ? */
bool CExtraction::viewExtractedDirectoryInKonqueror()
{
  return chLaunchKonqueror->isChecked();
}


int CExtraction::extractAll()
{
  if(qtarch_RadioButton_1->isChecked())
    return EXTRACT_ALL_FILES;
 else
    return EXTRACT_SELECTED_FILES;
}

/**Returns a regular expression, to sort which files should be extracted */
QString CExtraction::getRegExp()
{
  if(qtarch_cbregexp->isChecked())
    return le_regexp->text();
  else
    return "";
}

void CExtraction::dontExtract()
{
	reject();
}

void CExtraction::setDefaultOptions(QString& defaultExtractPath, int& defaultOptionExtract)
{
	optionextract=defaultOptionExtract;
	
	switch(defaultOptionExtract)
	{
		case 0:
			m_defaultExtractPath=defaultExtractPath;
			break;
		case 1:
			m_defaultExtractPath=QDir::homeDirPath();
			break;
		case 2:
			m_defaultExtractPath=QDir::currentDirPath();
			break;
	}
}

/** Set the default directory */
void CExtraction::setOptionExtraction(int optionExtract){
	optionextract=optionExtract;
}

/** Displays in the text box the default extraction direcrory */
void CExtraction::displayDefaultPath(){
  path="";
  cbExtractDirectory->setEditText(m_defaultExtractPath);
  repaint();
}

/** set the Most Recent Used extract dirs */
void CExtraction::setHistory(){
  QStrList list;
  KConfig *config = kapp->config();

  config->setGroup("LASTDIRS");

  config->readListEntry("LastExtractedDirs",list);
  
  history->setMaxElements(4);
  history->setElements(list);
  
  cbExtractDirectory->clear();
  cbExtractDirectory->insertStrList(history->getElements());
}

/** save the MRU entries */
void CExtraction::writeHistory(){
  KConfig *config = kapp->config();

  config->setGroup("LASTDIRS");

  config->writeEntry("LastExtractedDirs",history->getElements());
}
#include "cextraction.moc"
