/*
    nesrommetadata.cpp - Extract metadata(information) from NES ROM file.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "nesrommetadata.h"

#include <kmdcodec.h>

NesRomMetaData::NesRomMetaData()
 : Kamefu::DefaultRomMetaData()
{
}


NesRomMetaData::~NesRomMetaData()
{
}


Kamefu::RomMetaInformation NesRomMetaData::extractMetaInformation(KFileItem* item)
{
    return DefaultRomMetaData::extractMetaInformation(item);
}

Kamefu::RomMetaInformation NesRomMetaData::extractMetaInformation(QIODevice* device)
{
    Kamefu::RomMetaInformation romMetaData;
	QString md5Hash;

	// Generate the MD5 Hash
	KMD5 context(0L);
	context.update(*device);
	md5Hash = context.hexDigest();
	
	romMetaData.setMd5Hash(md5Hash);

	return romMetaData;
}

