/******************************************************************************
	romlistviewitem.h - Specialized list entry containing ROM path
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#ifndef ROMLISTVIEWITEM_H
#define ROMLISTVIEWITEM_H

#include <klistview.h>

#include <rommetainformation.h>

/**
	@brief An item to place in a KListView for indicating a ROM.
	For use in placing ROM information in a KListView. This class is necessary
	so we may always track the ROM URL with the item, saving unnecessary
	name -> URL lookups which may also be inaccurate.
	
	@author Brian S. Stephan <bssteph@incorporeal.org>
*/
class RomListViewItem : public KListViewItem {

public:
	/**
	 * Create a new ROM item.
	 * @param parent the list view this is placed in
	 * @param romMetaInfo information to seed the item with
	 */
	RomListViewItem(KListView *parent, const Kamefu::RomMetaInformation &romMetaInfo);
	
	/**
	 * Default Destructor
	 */
	~RomListViewItem();
	
	/**
	 * Set the columns to be displayed for this item
	 * @param romMetaInfo information to use in displaying the row
	 */
	void writeColumns(const Kamefu::RomMetaInformation &romMetaInfo);
	
	/**
	 * Refresh the ROM's metainformation and rewrite all columns
	 */
	void refreshInfo();
	
	/**
	 * Return the rom URL corresponding to this item.
	 * @return the ROM's URL
	 */
	QString romUrl();
	
private:
	class Private;
	Private *d;
};

#endif
