/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "kalleryglobals.h"

//KDE includes
#include <klocale.h>

//qt includes
#include <qdir.h>
#include <qfileinfo.h>

KalleryGlobals::KalleryGlobals()
{
}


KalleryGlobals::~KalleryGlobals()
{
}

void KalleryGlobals::setDefaultOptions()
{
  options.galleryTitle = i18n("Image gallery");
  options.galleryFile = QDir::currentDirPath()+"/myGallery/gallery.html";
  options.imageDestDir = QDir::currentDirPath()+"/myGallery/fullsize";
  options.thumbDestDir = QDir::currentDirPath()+"/myGallery/thumbs";
  options.relativePaths = true;
  options.imageList.clear();
  options.thumbList.clear();
  options.descList.clear();
  options.thumbSetting = OptionType::GenerateThumbnails;
  options.descSetting = OptionType::LoadImageInfo;
  options.infoSetting = OptionType::ImageInfoComment;
  options.thumbWidth = 150;
  options.thumbHeight = 100;
  options.fullWidth = 800;
  options.fullHeight = 600;
  options.convertImages = OptionType::Convert;
  options.resize = true;
  options.keepRatio = true;
  options.onlyLarger = true;
  options.thumbFormat = "jpg";
  options.fullFormat = "jpg";
  options.quality = 80; // == 80%
  options.columnNum = 3;
  options.useHtmlImages = true;
  options.textButtons = true;
  options.nextStr = i18n("Next");
  options.prevStr = i18n("Previous");
  options.backStr = i18n("Back");
  options.nextPic = m_baseDir + "images/next.png";
  options.prevPic = m_baseDir + "images/prev.png";
  options.backPic = m_baseDir + "images/back.png";
  options.imageBackColor.setNamedColor("#000000");
  options.imageTextColor.setNamedColor("#FFFFFF");
  options.imageVisitedColor.setNamedColor("#AAAAAA");
  options.insertCopyright = false;
  options.copyright = " " + i18n("(C) This year, You");
  options.galleryTemplate = i18n("Default template");
  options.fullsizeTemplate = i18n("Buttons above the image");
  options.language = i18n("United Kingdom (gb)");
  options.encoding = "utf8";
  options.useFrames = false;
  options.backColor.setNamedColor("#000000");
  options.tableColor.setNamedColor("#000000");
  options.textColor.setNamedColor("#FFFFFF");
  options.visitedColor.setNamedColor("#AAAAAA");
  options.galleryCSSFile = "";
  options.beforeHtmlFile = "";
  options.afterHtmlFile = "";
  options.imageCSSFile = "";
  options.projectFileName = "";
  options.fileName = "";

  //setCaption(i18n("Kallery wizard"));
  m_projectBaseDir = QFileInfo(options.galleryFile).dirPath()+"/";
}
