/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "imageoptionspage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qregexp.h>
#include <qslider.h>
#include <qspinbox.h>

ImageOptionsPage::ImageOptionsPage(QWidget *parent, const char *name)
    :KImageOptionsPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
  connect(QualitySlider,SIGNAL(valueChanged(int)),this,SLOT(slotQualityValueChanged(int)));
}

void ImageOptionsPage::slotQualityValueChanged(int value)
{
  QualityTxt->setText(QString("[%1%]").arg(value));
}

void ImageOptionsPage::invokeHelp()
{
  kapp->invokeHelp("imageoptions-page","kallery");
}

bool ImageOptionsPage::processPage()
{
  if (NoCopyConvertFull->isChecked())
    KalleryGlobals::ref()->options.convertImages = OptionType::NoCopyConvert;
  if (CopyFull->isChecked())
    KalleryGlobals::ref()->options.convertImages = OptionType::CopyOnly;
  if (ConvertFull->isChecked())
    KalleryGlobals::ref()->options.convertImages = OptionType::Convert;
  if (UseExistingImages->isChecked())
    KalleryGlobals::ref()->options.convertImages = OptionType::UseExisting;
  KalleryGlobals::ref()->options.resize = Resize->isChecked();
  KalleryGlobals::ref()->options.keepRatio = KeepAspect->isChecked();
  KalleryGlobals::ref()->options.onlyLarger = OnlyLarger->isChecked();
  KalleryGlobals::ref()->options.fullWidth = FullW->value();
  KalleryGlobals::ref()->options.fullHeight = FullH->value();
  KalleryGlobals::ref()->options.thumbWidth = ThumbW->value();
  KalleryGlobals::ref()->options.thumbHeight = ThumbH->value();
  KalleryGlobals::ref()->options.quality = QualitySlider->value();
  KalleryGlobals::ref()->options.fullFormat = FullImageFormat->currentText();
  KalleryGlobals::ref()->options.fullFormat = KalleryGlobals::ref()->options.fullFormat.right(KalleryGlobals::ref()->options.fullFormat.length()-KalleryGlobals::ref()->options.fullFormat.find("*.",1)-2);
  KalleryGlobals::ref()->options.fullFormat.truncate(KalleryGlobals::ref()->options.fullFormat.find(")",1));
  KalleryGlobals::ref()->options.thumbFormat = ThumbImageFormat->currentText();
  KalleryGlobals::ref()->options.thumbFormat = KalleryGlobals::ref()->options.thumbFormat.right(KalleryGlobals::ref()->options.thumbFormat.length()-KalleryGlobals::ref()->options.thumbFormat.find("*.",1)-2);
  KalleryGlobals::ref()->options.thumbFormat.truncate(KalleryGlobals::ref()->options.thumbFormat.find(")",1));
  KalleryGlobals::ref()->options.insertCopyright = InsertCopyright->isChecked();
  KalleryGlobals::ref()->options.copyright =  CopyrightTxt->text();

  return true;
}

void ImageOptionsPage::setupPage()
{
  int pos;
  int num;
  int thumbFormatNo;
  int fullFormatNo;
  QString tmpString;

  tmpString = KalleryGlobals::ref()->imageFilter();
  num = tmpString.contains('\n');
  ThumbImageFormat->clear();
  FullImageFormat->clear();
  for (int i=0 ; i < num; i++)
  {
    pos = tmpString.find('\n',1);
    if (i > 1)
    {
      ThumbImageFormat->insertItem(tmpString.left(pos));
      FullImageFormat->insertItem(tmpString.left(pos));
      if (tmpString.left(pos).find(QRegExp("."+KalleryGlobals::ref()->options.thumbFormat+"\\)"),0) != -1)
      {
        thumbFormatNo = i - 2;
      }
      if (tmpString.left(pos).find(QRegExp("."+KalleryGlobals::ref()->options.fullFormat+"\\)"),0) != -1)
      {
        fullFormatNo = i - 2;
      }
    }
    pos = tmpString.find('|',pos+1);
    tmpString.remove(0,pos+1);
  }

  ThumbImageFormat->setCurrentItem(thumbFormatNo);
  FullImageFormat->setCurrentItem(fullFormatNo);
  QualityTxt->setText(QString("[ %1% ]").arg(KalleryGlobals::ref()->options.quality));
  QualitySlider->setValue(KalleryGlobals::ref()->options.quality);

  ThumbFrame->setEnabled(KalleryGlobals::ref()->options.thumbSetting == OptionType::GenerateThumbnails);
  switch (KalleryGlobals::ref()->options.convertImages)
  {
    case OptionType::NoCopyConvert:  NoCopyConvertFull->setChecked(true);
                         break;
    case OptionType::CopyOnly: CopyFull->setChecked(true);
                   break;
    case OptionType::Convert:  ConvertFull->setChecked(true);
                   break;
    case OptionType::UseExisting: UseExistingImages->setChecked(true);
                      break;
  }

  Resize->setChecked(KalleryGlobals::ref()->options.resize);
  KeepAspect->setChecked(KalleryGlobals::ref()->options.keepRatio);
  OnlyLarger->setChecked(KalleryGlobals::ref()->options.onlyLarger);
  ThumbW->setValue(KalleryGlobals::ref()->options.thumbWidth);
  ThumbH->setValue(KalleryGlobals::ref()->options.thumbHeight);
  FullW->setValue(KalleryGlobals::ref()->options.fullWidth);
  FullH->setValue(KalleryGlobals::ref()->options.fullHeight);
  InsertCopyright->setChecked(KalleryGlobals::ref()->options.insertCopyright);
  CopyrightTxt->setText(KalleryGlobals::ref()->options.copyright);
}


#include "imageoptionspage.moc"
