/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLOPTIONSPAGE_H
#define HTMLOPTIONSPAGE_H

#include "khtmloptionspage.h"
#include "wizardpagebase.h"

/**
 * @short
 * Gallery HTML options page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class HtmlOptionsPage: public KHtmlOptionsPage, public WizardPageBase {
Q_OBJECT
public:
  HtmlOptionsPage(QWidget *parent = 0, const char *name = 0);
  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
  
  /**
   * Select the background color.
   */
  void slotSelectBackColor();
  
  /**
   * Select the table color.
   */
  void slotSelectTableColor();
  
  /**
   * Select the text and link color.
   */
  void slotSelectTextColor();
  
  /**
   * Select the visited link color.
   */
  void slotSelectVisitedColor();
  
  /**
   * Select a CSS file for the main html.
   */
  void slotSelectGalleryCSS();
  
  /**
   * Select a file containing text that will be inserted before the images.
   */
  void slotSelectAfterHtml();
  
  /**
   * Select a file containing text that will be inserted after the images.
   */
  void slotSelectBeforeHtml();
  
  /**
   * Called when the user selects a different template.
   * @param index index of the new template
   */
  void slotTemplateChanged(int index);

private:
  /**
   * Load gallery templates.
   */
  void loadTemplates();
  /**
   * Load the list of avaliable countries and put them into a combo box
   * This code is based on kdebase/kcontrol/locale/locale.cpp.
   * @param combo the combo where to put the result
   */
  void loadCountryList(QComboBox *combo);

  QStringList galleryTemplateList; ///< holds the loaded templates
  QValueList<int> defaultColumnsList; ///< the default value for columns for a template

};

#endif
