#!/usr/bin/ruby -Ke

kagemai_root = "/home/fukuoka/kagemai"        # setup
config_file  = "#{kagemai_root}/kagemai.conf" # setup

$: << "#{kagemai_root}/lib"
require 'kagemai/config'

Kagemai::Config.initialize(kagemai_root, config_file)

require 'kagemai/bts'
require 'kagemai/project'
require 'kagemai/message_bundle'
require 'kagemai/cgi/action'

module Kagemai
  MessageBundle.open(Config[:resource_dir], 
                     Config[:language], 
                     Config[:message_bundle_name])
  
  class NewReport
    def initialize(project_id)
      bts = BTS.new(Config[:project_dir])
      @project = bts.open_project(project_id)
    end
    
    def do(email, title, body)
      message = Message.new(@project.report_type)
        
      message['email'] = email
      message['title'] = title
      message['body']  = body
        
      message.set_option('email_notification', false)
        
      @project.new_report(message)
    end
  end
end

command = Kagemai::NewReport.new('project-id')
command.do('᡼륢ɥ쥹', '', 'ʸ')
