/*****************************************************************

Copyright (c) 2004 Zack Rusin <zrusin@kde.org>
                   Sami Kyostil <skyostil@kempele.fi>
                   Aaron J. Seigo <aseigo@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __KADU_OSD_WIDGET_H
#define __KADU_OSD_WIDGET_H

#include <qbitmap.h>
#include <qtimer.h>

#include "../notify/notify.h"
#include "../notify/notification.h"

#include "usergroup.h"
#include "kadu_text_browser.h"

class OSDWidget : public KaduTextBrowser
{
	Q_OBJECT

	public:
		enum MaskEffect { Plain, Dissolve };
		struct OSDData
		{
			QString message;
			MaskEffect maskEffect;
			int duration;
			QColor fg_color;
			QColor bg_color;
			QColor border_color;
			int x;
			int y;
			unsigned int id;
			float translucency_val;
		};

		OSDWidget(QWidget *parent, Notification *notification);
		OSDWidget(QWidget *parent);
		~OSDWidget();
		
		void prepare();
		void display();
		
		void setData(OSDData d) { m_data = d; }
		int getWidth() { return m_width; }
		int getHeight() { return m_height; }
		int getX() { return m_data.x; }
		int getY() { return m_data.y; }
		int getID() { return m_data.id; }
		
		const UserListElements & getUsers() const;
		bool hasUsers() const;
		Notification *getNotification() { return notification; }
		bool requireManualClosing();

	protected:
		QPopupMenu *createPopupMenu(const QPoint &point);
		virtual void enterEvent(QEvent *e);
		virtual void leaveEvent(QEvent *e);
		virtual void contentsWheelEvent(QWheelEvent *e);
	
		Notification *notification;
		bool haveCallbacks;

	private:
		friend class OSDPreviewWidget;
		
		void drawBorder();
		QImage fade(QImage, const float, const QColor &);
		void plainMask();

		void buttonPressed(QString button);

		QPixmap background, background_light;
		QBitmap m_mask;
		int m_width;
		int m_height;
		OSDData m_data;
		
		int m_dissolveSize;
		QTimer m_frameTimer;
		QHBoxLayout *callbacksBox;

	private slots:
		void notificationClosed();
		void dissolveMask();
		void timeout(bool b = false);
		void mouseReleaseEvent(QMouseEvent *event);

	public slots:
		void setX(int x) {m_data.x = x;}
		void setY(int y) {m_data.y = y;}
		void setID(int id) {m_data.id = id;}
		void acceptNotification();
		void discardNotification();

	signals:
		void timeout(int, bool);
		void deleteAll(void);

		void leftButtonClicked(OSDWidget *widget);
		void rightButtonClicked(OSDWidget *widget);
		void midButtonClicked(OSDWidget *widget);
		void closing(OSDWidget *widget);
		void updated(OSDWidget *widget);
};


class OSDPreviewWidget : public OSDWidget
{
	Q_OBJECT

	public:
		OSDPreviewWidget(QWidget *parent);
	
	public slots:
		void doUpdate();
		
	protected:
		virtual void contentsMousePressEvent(QMouseEvent *e);
		virtual void contentsMouseMoveEvent(QMouseEvent *e);

	private:
		bool m_dragging;
		QPoint m_dragOffset;
		
	private slots:
		void mouseReleased(QMouseEvent *);

	signals:
		void positionChanged(int, int);
};

#endif
