#ifdef WITH_KDE
#include <kaction.h>
#include <kapp.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kstdaction.h>
#else
#include <qapplication.h>
#include <qmenubar.h>
#include <qmainwindow.h>
#include <qmessagebox.h>
#endif
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qsocketnotifier.h>
#include <qvbox.h>
#include <qhbox.h>

#include <stdio.h>
#include <stdlib.h>
#include <alsa/asoundlib.h>
#include <poll.h>

#include "alsa_access.h"
#include "connector.h"
#include "portlistbox.h"


#define DEFAULT_WIDTH         500
#define CONNECTOR_WIDTH       150

int main(int argc, char **argv) {
#ifdef WITH_KDE
    static KCmdLineOptions options[] =
        {{"height <pixel>", I18N_NOOP("Height"), "250"}};
    QString aboutText ("KDE aconnect\n"
#else
    QString aboutText (" Kaconnect\n"
#endif
                       " by Matthias Nagorni\n"
                       " (c)2001 SuSE GmbH Nuremberg\n"
                       " (c)2002 SuSE AG Nuremberg\n\n"
                       " This program uses code of the\n"
                       " aconnect tool by Takashi Iwai");
#ifdef WITH_KDE
    KCmdLineArgs::init(argc, argv, "kaconnect", aboutText, "1.0.0");
    KCmdLineArgs::addCmdLineOptions(options);
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    int list_box_height = atoi(args->getOption("height"));
    KApplication app;
    KMainWindow *top = new KMainWindow();
#else
    QApplication *qApp = new QApplication(argc, argv);
    QMainWindow *top = new QMainWindow();
    QMessageBox *aboutWidget = new QMessageBox(top);
    int list_box_height = 250;
    QPopupMenu *aboutMenu = new QPopupMenu(top);    
#endif
    QPopupMenu *filePopup = new QPopupMenu(top);
#ifdef WITH_KDE
    KAction *quitAction = KStdAction::quit(&app, SLOT(quit()));
    quitAction->plug(filePopup);
#endif

    QVBox *view = new QVBox(top);
    view->setMargin(10);
    view->setSpacing(10);
    QHBox *labelBox = new QHBox(view);
    QHBox *listBox = new QHBox(view); 
    QHBox *buttonBox = new QHBox(view);

    AlsaHandle *seq_handle = new AlsaHandle(top);
    PortListBox *alsa_plist_r_box = new PortListBox(listBox, seq_handle->seq, 1);
    ConnectorWidget *connector = new ConnectorWidget(listBox, seq_handle->seq);
    PortListBox *alsa_plist_w_box = new PortListBox(listBox, seq_handle->seq, 0);
    connector->setMinimumWidth(CONNECTOR_WIDTH);
    connector->set_r_listBox(alsa_plist_r_box); 
    connector->set_w_listBox(alsa_plist_w_box);
    connector->updateConnector(0);
    QLabel *dummyButtonLabel1 = new QLabel(buttonBox);    
    QPushButton *subscribe = new QPushButton("connect", buttonBox);
    QLabel *dummyButtonLabel2 = new QLabel(buttonBox);
    dummyButtonLabel2->setMaximumWidth(30);
    QPushButton *unsubscribe = new QPushButton("disconnect", buttonBox);
    QLabel *dummyButtonLabel3 = new QLabel(buttonBox);
   
    QLabel *r_ports_text = new QLabel(labelBox);
    r_ports_text->setFont(QFont("Arial", 16));  
    r_ports_text->setText("Readable Ports:");

    QLabel *dummyLabel = new QLabel(labelBox);   
    dummyLabel->setMaximumWidth(CONNECTOR_WIDTH);

    QLabel *w_ports_text = new QLabel(labelBox);
    w_ports_text->setFont(QFont("Arial", 16));  
    w_ports_text->setText("Writeable Ports:");  
    
    snd_seq_port_subscribe_t *subs;
    snd_seq_addr_t tmp_addr;
    int portid; 
    int alsaAnnounceFd = 0;
    if (!(portid = snd_seq_create_simple_port(seq_handle->seq, "kaconnect", 
            SND_SEQ_PORT_CAP_WRITE|SND_SEQ_PORT_CAP_SUBS_WRITE|SND_SEQ_PORT_CAP_NO_EXPORT, 
            SND_SEQ_PORT_TYPE_APPLICATION) < 0)) {
        snd_seq_port_subscribe_alloca(&subs);
        tmp_addr.client = SND_SEQ_CLIENT_SYSTEM;
        tmp_addr.port = SND_SEQ_PORT_SYSTEM_ANNOUNCE;
        snd_seq_port_subscribe_set_sender(subs, &tmp_addr);
        tmp_addr.client = snd_seq_client_id(seq_handle->seq);
        tmp_addr.port = portid;
        snd_seq_port_subscribe_set_dest(subs, &tmp_addr);       
        snd_seq_subscribe_port(seq_handle->seq, subs);
        struct pollfd pfd[1];
        snd_seq_poll_descriptors(seq_handle->seq, pfd, 1, POLLIN);
        alsaAnnounceFd = pfd[0].fd;
    }
    QSocketNotifier *alsaNotifier = new QSocketNotifier(alsaAnnounceFd, QSocketNotifier::Read);
    top->menuBar()->insertItem("&File", filePopup);
#ifdef WITH_KDE
    top->menuBar()->insertSeparator();
    top->menuBar()->insertItem(i18n("&Help"), top->helpMenu());
#else
    filePopup->insertItem("&Quit", qApp, SLOT(quit()));
    top->menuBar()->insertSeparator();
    top->menuBar()->insertItem("&About", aboutMenu);
    aboutMenu->insertItem("About Kaconnect", aboutWidget, SLOT(exec()));
#endif
    QObject::connect(alsaNotifier, SIGNAL(activated(int)),
                     seq_handle, SLOT(alsaAnnounce(int)));   
    QObject::connect(alsaNotifier, SIGNAL(activated(int)),
                     alsa_plist_r_box, SLOT(updateList(int)));   
    QObject::connect(alsaNotifier, SIGNAL(activated(int)),
                     alsa_plist_w_box, SLOT(updateList(int)));   

    QObject::connect(alsaNotifier, SIGNAL(activated(int)),
                     connector, SLOT(updateConnector(int)));
    QObject::connect(subscribe, SIGNAL(clicked()),
                     connector, SLOT(subscribe()));   
    QObject::connect(unsubscribe, SIGNAL(clicked()),
                     connector, SLOT(unsubscribe()));   
    QObject::connect(alsa_plist_r_box, SIGNAL(highlighted(int)),
                     connector, SLOT(checkEqual(int)));   
    QObject::connect(alsa_plist_w_box, SIGNAL(highlighted(int)),
                     connector, SLOT(checkEqual(int)));   
    QObject::connect(connector, SIGNAL(isEqual(bool)),
                     subscribe, SLOT(setDisabled(bool)));   
    QObject::connect(alsa_plist_r_box, SIGNAL(contentsMoving(int, int)),
                     connector, SLOT(move(int, int)));
    QObject::connect(alsa_plist_w_box, SIGNAL(contentsMoving(int, int)),
                     connector, SLOT(move(int, int)));       

    top->setGeometry(0, 0, DEFAULT_WIDTH, list_box_height);
    top->show();
    top->setCentralWidget(view);
#ifdef WITH_KDE
    app.setMainWidget(top);
    return app.exec();
#else
    qApp->setMainWidget(top);   
    aboutWidget->setText(aboutText);
    aboutWidget->setCaption("About Kaconnect");   
    aboutWidget->hide();  
    return qApp->exec();
#endif
}
