#ifndef _CONNECTORWIDGET_H_
#define _CONNECTORWIDGET_H_

#include <qwidget.h>
#include "portlistbox.h"
#include <alsa/asoundlib.h>

#define ARROW_LENGTH 16.0
#define ARROW_PHI    0.3

class QPaintEvent;

class ConnectorWidget : public QWidget {

    Q_OBJECT
    
    private:
        snd_seq_t *seq;
        PortListBox *r_portlist;
        PortListBox *w_portlist;
        bool connected[PORTLISTBOX_MAX_PORTS][PORTLISTBOX_MAX_PORTS];

    private:
        void arrow(int x1, int y1, int x2, int y2); 
   
    public:
        ConnectorWidget::ConnectorWidget(QWidget *parent, snd_seq_t *pseq); 
        void set_r_listBox(PortListBox *p_r_portlist);
        void set_w_listBox(PortListBox *p_w_portlist);
                   
    protected:
        void paintEvent(QPaintEvent *);

    signals:
        void isEqual(bool equal);  

    public slots:
        void move(int x, int y);
        void checkEqual(int index);
        void updateConnector(int n);
        void subscribe();
        void unsubscribe();
};

#endif
