########################################################
# K3D_WITH_IMAGEMAGICK

AC_DEFUN([K3D_WITH_IMAGEMAGICK], [
AC_SUBST(K3D_IMAGEMAGICK_CPPFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_CXXFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_LIBS)
AC_SUBST(K3D_IMAGEMAGICK_LDFLAGS)
AC_SUBST(K3D_IMAGEMAGICK_SUBDIR)

K3D_IMAGEMAGICK_CPPFLAGS=""
K3D_IMAGEMAGICK_CXXFLAGS=""
K3D_IMAGEMAGICK_LIBS=""
K3D_IMAGEMAGICK_LDFLAGS=""
K3D_IMAGEMAGICK_SUBDIR=""

AC_ARG_WITH(imagemagick, [  --with-imagemagick      test for ImageMagick Magick++ API [[yes]]],[],[withval=yes])

if test x$withval = xyes; then

	AC_MSG_CHECKING([for Magick++])
	if  Magick++-config --version >/dev/null 2>/dev/null; then
		AC_MSG_RESULT([found])
                K3D_IMAGEMAGICK_CPPFLAGS=`Magick++-config --cppflags`
                K3D_IMAGEMAGICK_CXXFLAGS=`Magick++-config --cxxflags`
                K3D_IMAGEMAGICK_LIBS=`Magick++-config --libs`
                K3D_IMAGEMAGICK_LDFLAGS=`Magick++-config --ldflags`
		K3D_IMAGEMAGICK_SUBDIR="imagemagick"
	else
		AC_MSG_RESULT([
It appears that you don't have an installation of the ImageMagick Magick++ API.
ImageMagick is a collection of programs that read and write a large number of 
bitmap file formats.  K-3D relies on ImageMagick in order to read and write
bitmap images for use as textures, so a working ImageMagick installation is 
highly recommended.  In addition, you need the ImageMagick development libraries
and/or packages, including Magick++, a C++ API for ImageMagick.
])
	fi
fi

])

