# $Id: GDBM_File.pm,v 1.1.1.1 2005/06/28 04:25:15 kuro Exp $
package Juman::GDBM_File;
require 5.000;
use Carp qw/ croak /;
use English qw/ $PERL_VERSION /;
use GDBM_File qw/ GDBM_WRCREAT GDBM_READER GDBM_WRITER /;
use POSIX qw/ O_CREAT O_RDONLY O_RDWR O_WRONLY /;
use strict;
use vars qw/ @EXPORT @ISA /;
@ISA = qw/ GDBM_File /;
@EXPORT = qw/ O_CREAT O_RDONLY O_RDWR O_WRONLY GDBM_WRCREAT GDBM_READER GDBM_WRITER /;

=head1 NAME

Juman::GDBM_File - Wrapper class of GDBM_File

=head1 SYNOPSIS

 use Juman::GDBM_File;
 use encoding "euc-jp";
 tie( %hash, 'Juman::GDBM_File', $dbfile, &GDBM_WRCREAT, 0640 ) or die;
 $hash{"ź"} = "";
 while( my( $key, $value ) = each %hash ){
     print "$key:$value\n";
 }

=head1 DESCRIPTION

Perl-5.8.x ʸɤȤ Unicode ѤƤ롥Τᡤ
ܸ EUC ǵҤ줿ǡ١ե򻲾Ȥˤϡź
񤭹ꡤɤ߽ФꤹˡŪ encode/decode 
ɬפ롥

 C<Juman::GDBM_File> 饹ϡʸɤ¸Ƥǡ
١ե򰷤ˡƩŪ encode/decode Ԥ

=head1 ENCODING

Υ饹Ѥϡǡ١Ȥϻ˻Ȥʸɤ
C<encoding> ץ饰ޤǻꤹ롥C<encoding> ץ饰ޤˤ꤬¸ߤ
ʤϡޤäѴԤʤ

=cut
BEGIN {
    if( $PERL_VERSION > 5.008 ){
	require Juman::Encode;
	Juman::Encode->import( qw/ encode decode / );
    } else {
	*{Juman::GDBM_File::encode} = sub { $_[0]; };
	*{Juman::GDBM_File::decode} = sub { $_[0]; };
    }
}

# ǡ١˥᥽åɤ񤭤Ƥ롥ɬפʥ᥽åɤ
# ܺ٤ˤĤƤϡperldoc perltie 򻲾ȡ
sub FETCH {
    my( $this, $key ) = @_;
    &decode( $this->SUPER::FETCH( &encode( $key ) ) );
}

sub STORE {
    my( $this, $key, $value ) = @_;
    $this->SUPER::STORE( &encode( $key ), &encode( $value ) );
}

sub DELETE {
    my( $this, $key ) = @_;
    $this->SUPER::DELETE( &encode( $key ) );
}

sub EXISTS {
    my( $this, $key ) = @_;
    $this->SUPER::EXISTS( &encode( $key ) );
}

sub FIRSTKEY {
    my( $this ) = @_;
    &decode( $this->SUPER::FIRSTKEY() );
}

sub NEXTKEY {
    my( $this, $lastkey ) = @_;
    &decode( $this->SUPER::NEXTKEY( &encode( $lastkey ) ) );
}

=head1 CONSTRUCTOR

C<GDBM_File> Ʊν񼰤ǡϢǤ롥

    tie( %hash, 'Juman::GDBM_File', $dbfile, &GDBM_WRCREAT, 0640 );

5ˤϡǡ١ե򿷵Υե°
ꤵƤ롥

5άϡC<DB_File> ߴν񼰤ȤƤȸʤ
롥

    tie( %hash, 'Juman::GDBM_File', $dbfile, &O_CREAT );

ξ硤ǡ١ե򳫤⡼ɤꤷƤ4ˤϡ
C<O_CREAT>, C<O_RDWR> ʤ C<DB_File> Υǡ١򳫤Ʊ
Ȥǡ١ե򿷵Υե°ϡ
C<umask> ֤ͤ鼫ưŪ˻Ф롥

=cut
sub TIEHASH {
    my $class = shift;
    my $name  = shift;
    my $mode  = shift;
    my $permission;
    if( @_ ){ # GDBM_File style
	$permission = shift;
    } else {  # DB_File style
	if ( $mode == &O_CREAT ) {
	    $mode = &GDBM_WRCREAT;
	} elsif ( $mode == &O_RDONLY ) {
	    $mode = &GDBM_READER;
	} elsif ( $mode == &O_RDWR ) {
	    $mode = &GDBM_READER | &GDBM_WRITER;
	} elsif ( $mode == &O_WRONLY ) {
	    $mode = &GDBM_WRITER;
	} else {
	    croak "$class (TIEHASH): Unknown mode $mode is specified";
	}
	$permission = 0666 & (~umask);
    }
    my $new = GDBM_File->TIEHASH( $name, $mode, $permission );
    bless $new, $class;
}

1;

=head1 SEE ALSO

=over 4

=item *

L<GDBM_File>

=item *

L<perltie>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
