import time


class CachedValue(object):

    def __init__(self, max_cache, value=None):
        self._max_cache = max_cache
        self.set(value)

    def get(self):
        delta = time.time() - self._timestamp
        if delta > self._max_cache:
            return None
        return self._value

    def set(self, value):
        self._value = value
        self._timestamp = time.time()
