from yaml import dump

from twisted.internet.defer import inlineCallbacks

from juju.control import main
from .common import MachineControlToolTest


class ControlJujuSetTest(MachineControlToolTest):

    @inlineCallbacks
    def setUp(self):
        yield super(ControlJujuSetTest, self).setUp()
        config = {
            "environments": {"firstenv": {"type": "dummy"}}}
        self.write_config(dump(config))
        self.config.load()
        self.service_state = yield self.add_service_from_charm("wordpress")
        self.service_unit = yield self.service_state.add_unit_state()
        self.stderr = self.capture_stream("stderr")

    @inlineCallbacks
    def test_set_and_get(self):
        finished = self.setup_cli_reactor()
        self.setup_exit(0)
        self.mocker.replay()

        main(["set",
              "wordpress",
              "blog-title=Hello Tribune?"])
        yield finished

        # Verify the state is accessible
        state = yield self.service_state.get_config()
        self.assertEqual(state, {"blog-title": "Hello Tribune?"})

    @inlineCallbacks
    def test_set_invalid_option(self):
        finished = self.setup_cli_reactor()
        self.setup_exit(0)
        self.mocker.replay()
        main(["set",
              "wordpress",
              "blog-roll=What's a blog-roll?"])
        yield finished

        # Make sure we got an error message to the user
        self.assertIn("blog-roll is not a valid configuration option.",
                      self.stderr.getvalue())

    @inlineCallbacks
    def test_set_invalid_service(self):
        finished = self.setup_cli_reactor()
        self.setup_exit(0)
        self.mocker.replay()

        main(["set",
              "whatever",
              "blog-roll=What's a blog-roll?"])
        yield finished

        self.assertIn("Service 'whatever' was not found",
                      self.stderr.getvalue())

    @inlineCallbacks
    def test_set_valid_option(self):
        finished = self.setup_cli_reactor()
        self.setup_exit(0)
        self.mocker.replay()

        main(["set",
              "wordpress",
              'blog-title=My title'])
        yield finished

        # Verify the state is accessible
        state = yield self.service_state.get_config()
        self.assertEqual(state, {"blog-title": "My title"})
