"""Implementation of remove unit subcommand"""

from twisted.internet.defer import inlineCallbacks

from juju.state.service import ServiceStateManager
from juju.control.utils import get_environment


def configure_subparser(subparsers):
    """Configure remove-unit subcommand"""
    sub_parser = subparsers.add_parser("remove-unit", help=command.__doc__)
    sub_parser.add_argument(
        "--environment", "-e",
        help="juju environment to operate in.")
    sub_parser.add_argument(
        "unit_name",
        help="Name of the unit to remove.")
    return sub_parser


def command(options):
    """Remove a service unit."""
    environment = get_environment(options)
    return remove_unit(
        options.environments,
        environment,
        options.verbose,
        options.log,
        options.unit_name)


@inlineCallbacks
def remove_unit(config, environment, verbose, log, unit_name):
    provider = environment.get_machine_provider()
    client = yield provider.connect()
    service_manager = ServiceStateManager(client)

    service_name, _ = unit_name.split("/")
    service_state = yield service_manager.get_service_state(service_name)
    unit_state = yield service_state.get_unit_state(unit_name)

    yield service_state.remove_unit_state(unit_state)
    yield client.close()

    log.info("Unit %r removed from service %r",
        unit_state.unit_name, service_state.service_name)
