/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.outlookClasses;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.wikiwizard.outlookClasses.ButtonBorder;
import org.wikiwizard.outlookClasses.FourLineBorder;

public class BasicOutlookButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicOutlookButtonUI();
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.setOpaque(false);
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        LookAndFeel.installBorder(b, "OutlookButton.border");
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }

    public static class OutlookButtonBorder
    extends ButtonBorder {
        FourLineBorder rolloverBorder;
        FourLineBorder pressedBorder;

        public OutlookButtonBorder(Color color1, Color color2) {
            this.rolloverBorder = new FourLineBorder(color1, color1, color2, color2);
            this.pressedBorder = new FourLineBorder(color2, color2, color1, color1);
        }

        protected void paintRollover(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.rolloverBorder.paintBorder(b, g, x, y, width, height);
        }

        protected void paintPressed(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.pressedBorder.paintBorder(b, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.rolloverBorder.getBorderInsets(c);
        }
    }
}

