/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.jButtonBar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import org.wikiwizard.jButtonBar.BlueishButtonBarUI;
import org.wikiwizard.jButtonBar.ButtonBarButtonUI;
import org.wikiwizard.jButtonBar.ButtonBarUI;
import org.wikiwizard.jButtonBar.JButtonBarAddon;
import org.wikiwizard.jButtonBar.LookAndFeelAddons;

public class JButtonBar
extends JComponent
implements Scrollable,
SwingConstants {
    public static final String UI_CLASS_ID = "ButtonBarUI";
    public static final String ORIENTATION_CHANGED_KEY = "orientation";
    private int orientation;
    private static PropertyChangeListener uiUpdater;
    private static ContainerListener buttonTracker;

    public JButtonBar() {
        this(0);
    }

    public JButtonBar(int orientation) {
        this.orientation = orientation;
        this.updateUI();
        this.addContainerListener(buttonTracker);
    }

    public void updateUI() {
        UIManager.put(UI_CLASS_ID, BlueishButtonBarUI.class.getName());
        this.setUI((ButtonBarUI)LookAndFeelAddons.getUI(this, ButtonBarUI.class));
    }

    public ButtonBarUI getUI() {
        return (ButtonBarUI)this.ui;
    }

    public void setUI(ButtonBarUI ui) {
        super.setUI(ui);
        Component[] components = this.getComponents();
        int c = components.length;
        for (int i = 0; i < c; ++i) {
            if (!(components[i] instanceof AbstractButton)) continue;
            ui.installButtonBarUI((AbstractButton)components[i]);
        }
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (this.orientation != orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_CHANGED_KEY, oldOrientation, this.orientation);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.getParent().getWidth(), height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, this.getPreferredHeight());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int hundredth = (orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth()) / 100;
        return hundredth == 0 ? 1 : hundredth;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private int getPreferredHeight() {
        int rv = 0;
        int count = this.getComponentCount();
        for (int k = 0; k < count; ++k) {
            Component comp = this.getComponent(k);
            Rectangle r = comp.getBounds();
            int height = r.y + r.height;
            if (height <= rv) continue;
            rv = height;
        }
        return rv += ((FlowLayout)this.getLayout()).getVgap();
    }

    static {
        LookAndFeelAddons.contribute(new JButtonBarAddon());
        uiUpdater = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractButton button;
                if (evt.getSource() instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).getParent() instanceof JButtonBar && !(button.getUI() instanceof ButtonBarButtonUI)) {
                    ((ButtonBarUI)((JButtonBar)button.getParent()).ui).installButtonBarUI(button);
                }
            }
        };
        buttonTracker = new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                JButtonBar container = (JButtonBar)e.getContainer();
                if (e.getChild() instanceof AbstractButton) {
                    ((ButtonBarUI)container.ui).installButtonBarUI((AbstractButton)e.getChild());
                    ((AbstractButton)e.getChild()).addPropertyChangeListener("UI", uiUpdater);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof AbstractButton) {
                    ((AbstractButton)e.getChild()).removePropertyChangeListener("UI", uiUpdater);
                }
            }
        };
    }
}

